package cn.bizvane.rocketmq.spring.core.consumer;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author wang.zeyan
 * @date 2019/08/21
 */
public interface ConsumerBean {

    /**
     * <consumerGroup, Map<topic:tag, RocketMQListener>
     */
    Map<String, Map<String , RocketMQListener>> SUBSCRIPTION_TABLE = Maps.newHashMap();

    /**
     * start
     */
    void start();

    /**
     * shutdown
     */
    void shutdown();

    /**
     * isStarted
     * @return
     */
    boolean isStarted();

    /**
     * isClosed
     * @return
     */
    boolean isClosed();

    /**
     * 获取订阅关系table
     * @return
     */
    default Map<String /* consumerGroup */, Map<String /* topic:tag */, RocketMQListener>> getSubscriptionTable() {
        return SUBSCRIPTION_TABLE;
    }
}
