/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.copyright.Copyright;

public abstract class AbstractCopyright {
    protected Copyright c;
    private String correctCopyright;
    private Pattern cpat;
    private Pattern acpat;
    private static String correctBSDCopyright;
    private static Pattern sunpat;
    private static Pattern apat;
    private static Pattern sunapat;
    private static Pattern anewpat;
    private static Pattern sunanewpat;
    private static Pattern mitspat;
    private static Pattern bpat;
    private static Pattern anpat;
    private static Pattern oapat;
    private static Pattern sunbpat;
    private static Pattern cnocepat;
    private static Pattern ocpat;
    private static Pattern oc2pat;
    private static Pattern njcpat;
    protected static Pattern ypat;
    private static Pattern endPat;
    private static Pattern secLicPat;
    private static Pattern crpat;
    private static Pattern cspat;
    private static Pattern bsdpat;
    protected static final String licensor = "Oracle and/or its affiliates";
    protected static final String allrights = "All rights reserved.";
    protected static final String thisYear;

    public AbstractCopyright(Copyright c) {
        this.c = c;
        try {
            if (c.correctTemplate != null) {
                this.correctCopyright = AbstractCopyright.getCopyrightText(c.correctTemplate);
                this.cpat = AbstractCopyright.getCopyrightPattern(c.correctTemplate);
            } else {
                this.correctCopyright = AbstractCopyright.getCopyrightText("cddl+gpl+ce-copyright.txt");
                this.cpat = AbstractCopyright.getCopyrightPattern("cddl+gpl+ce-copyright.txt");
            }
            if (c.alternateTemplate != null) {
                this.acpat = AbstractCopyright.getCopyrightPattern(c.alternateTemplate);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't load copyright template", ex);
        }
    }

    protected abstract boolean supports(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCopyright(File file) throws IOException {
        String lc = null;
        if (this.c.skipNoSVN && !this.isModified(file.getPath()) && (lc = this.lastChanged(file.getPath())).length() == 0) {
            return;
        }
        BufferedReader r = null;
        String comment = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "iso-8859-1"));
            comment = this.readComment(r);
            if (this.c.debug) {
                System.out.println("Comment for: " + file);
                System.out.println("---");
                System.out.println(comment);
                System.out.println("---");
            }
            if (this.c.warn && !this.c.quiet) {
                this.warnCopyright(file, r);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        if (comment == null) {
            this.err(file + ": No copyright");
            ++this.c.nMissing;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.MISSING);
            }
            return;
        }
        if (comment.trim().length() == 0) {
            this.err(file + ": Empty copyright");
            ++this.c.nEmpty;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.MISSING);
            }
            return;
        }
        if (!cspat.matcher(comment).find()) {
            this.err(file + ": No copyright");
            ++this.c.nMissing;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.MISSING);
            }
            return;
        }
        if (!(this.matches(this.cpat, comment) || this.acpat != null && this.matches(this.acpat, comment) || this.matches(apat, comment) || this.matches(anewpat, comment) || this.matches(mitspat, comment) || this.matches(bpat, comment) || this.matches(anpat, comment) || this.matches(oapat, comment))) {
            if (this.matches(sunpat, comment)) {
                this.err(file + ": Sun copyright");
                ++this.c.nSun;
            } else if (this.matches(sunapat, comment) || this.matches(sunanewpat, comment)) {
                this.err(file + ": Sun+Apache copyright");
                ++this.c.nSunApache;
            } else if (this.matches(sunbpat, comment)) {
                this.err(file + ": Sun BSD copyright");
                ++this.c.nSunBSD;
            } else if (this.matches(ocpat, comment) || this.matches(oc2pat, comment)) {
                this.err(file + ": Old CDDL copyright");
                ++this.c.nOldCDDL;
            } else if (this.matches(cnocepat, comment)) {
                this.err(file + ": CDDL+GPL-CE copyright");
                ++this.c.nNoCE;
            } else {
                this.err(file + ": Wrong copyright");
                ++this.c.nWrong;
            }
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.WRONG);
            }
            return;
        }
        if (this.matches(anpat, comment)) {
            return;
        }
        Matcher m = ypat.matcher(comment);
        if (!m.find()) {
            this.err(file + ": No copyright year");
            ++this.c.nNoYear;
            return;
        }
        if (this.c.ignoreYear) {
            return;
        }
        String year = m.group(2);
        if (this.isModified(file.getPath())) {
            lc = thisYear;
        } else if (lc == null) {
            lc = this.lastChanged(file.getPath());
        }
        String lastYear = year.substring(year.length() - 4);
        if (!lastYear.equals(lc)) {
            this.err(file + ": Copyright year is wrong; is " + lastYear + ", should be " + lc);
            ++this.c.nDate;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.DATE);
            }
            return;
        }
    }

    protected boolean matches(Pattern pat, String s) {
        return pat.matcher(s).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repair(File file, String comment, RepairType type) throws IOException {
        File newfile = new File(file.getParent(), file.getName() + ".new");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "iso-8859-1"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newfile), "iso-8859-1"));
            switch (type) {
                case MISSING: {
                    this.replaceCopyright(in, out, null, thisYear);
                    break;
                }
                case WRONG: {
                    this.replaceCopyright(in, out, comment, thisYear);
                    break;
                }
                case DATE: {
                    if (this.c.normalize) {
                        this.replaceCopyright(in, out, comment, thisYear);
                        break;
                    }
                    this.updateCopyright(in, out, thisYear);
                }
            }
            this.copy(in, out, true);
            if (!this.c.dontUpdate) {
                in.close();
                out.close();
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(newfile), "iso-8859-1"));
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "iso-8859-1"));
                this.copy(in, out, false);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (!this.c.dontUpdate) {
                newfile.delete();
            }
        }
    }

    protected void writeCopyright(BufferedWriter out, String year, String comment) throws IOException {
        String copyright = this.correctCopyright;
        String secondaryLicense = null;
        if (comment != null) {
            if (bsdpat.matcher(comment).find()) {
                copyright = correctBSDCopyright;
            } else {
                Matcher m = secLicPat.matcher(comment);
                if (m.find() && (secondaryLicense = comment.substring(m.start())).length() > 0) {
                    copyright = copyright + "\n\n" + secondaryLicense;
                }
            }
        }
        out.write(this.toComment(this.fixCopyright(copyright, year, licensor)));
    }

    protected abstract void replaceCopyright(BufferedReader var1, BufferedWriter var2, String var3, String var4) throws IOException;

    protected abstract void updateCopyright(BufferedReader var1, BufferedWriter var2, String var3) throws IOException;

    protected abstract String toComment(String var1);

    protected abstract String readComment(BufferedReader var1) throws IOException;

    protected void warnCopyright(File file, BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            Matcher m = ypat.matcher(line);
            if (!m.find() || line.indexOf(licensor) >= 0) continue;
            System.out.println(file + ": WARNING: extra copyright: " + line);
        }
    }

    protected void copy(BufferedReader in, BufferedWriter out, boolean skipBlanks) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (skipBlanks) {
                if (line.trim().length() == 0) continue;
                skipBlanks = false;
            }
            out.write(line);
            out.write(10);
        }
    }

    protected String addCopyrightDate(String date, String lastChanged) {
        if (date.length() == 4) {
            if (!date.equals(lastChanged)) {
                date = date + (this.c.useComma ? ", " : "-") + lastChanged;
            }
        } else {
            String lastDate = date.substring(date.length() - 4, date.length());
            if (!lastDate.equals(lastChanged)) {
                if (date.charAt(date.length() - 5) == '-') {
                    date = date.substring(0, date.length() - 4) + lastChanged;
                } else if (!(date = date.substring(0, 4)).equals(lastChanged)) {
                    date = date + (this.c.useComma ? ", " : "-") + lastChanged;
                }
            }
        }
        return date;
    }

    protected String fixCopyright(String cr, String date, String lic) {
        Matcher m = crpat.matcher(cr);
        return m.replaceFirst(date + " " + lic + ". " + allrights);
    }

    protected static String strip(String line) {
        for (int i = line.length() - 1; i >= 0; --i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return line.substring(0, i + 1);
        }
        return "";
    }

    protected static String findPrefix(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '\"' && c != '[' && c != '(') continue;
            return line.substring(0, i);
        }
        return "";
    }

    protected static boolean startsWith(String s, String prefix) {
        return s.trim().regionMatches(true, 0, prefix, 0, prefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean startsWith(File file, String prefix) {
        boolean bl;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(file));
            int len = prefix.length();
            for (int i = 0; i < len; ++i) {
                int c;
                while ((c = r.read()) == 13) {
                }
                if (c == prefix.charAt(i)) continue;
                boolean bl2 = false;
                return bl2;
            }
            bl = true;
            return bl;
        }
        catch (IOException ex) {
            bl = false;
            return bl;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    private static Pattern getCopyrightPattern(String name) throws IOException {
        return AbstractCopyright.copyrightToPattern(AbstractCopyright.readCopyright(name, true));
    }

    private static Pattern getCopyrightPattern(File file) throws IOException {
        return AbstractCopyright.copyrightToPattern(AbstractCopyright.readCopyright(file, true));
    }

    private static Pattern copyrightToPattern(String comment) {
        StringBuilder copyright = new StringBuilder();
        copyright.append("(\\QTo change this template, choose Tools | Templates\nand open the template in the editor.\n\n\\E)?");
        copyright.append(comment);
        return Pattern.compile(copyright.toString(), 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readCopyright(String name, boolean pattern) throws IOException {
        BufferedReader r = null;
        try {
            InputStream is = Copyright.class.getResourceAsStream("/META-INF/copyright-templates/" + name);
            if (is == null) {
                is = Copyright.class.getResourceAsStream(name);
            }
            r = new BufferedReader(new InputStreamReader(is));
            String string = AbstractCopyright.readCopyrightStream(r, pattern);
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readCopyright(File file, boolean pattern) throws IOException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(file));
            String string = AbstractCopyright.readCopyrightStream(r, pattern);
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private static String readCopyrightStream(BufferedReader r, boolean pattern) throws IOException {
        StringBuilder copyright = new StringBuilder();
        String line = r.readLine();
        while ((line = r.readLine()) != null && !line.equals(" */")) {
            line = line.length() > 2 ? line.substring(3) : "";
            if (pattern && (line = Pattern.quote(line)).indexOf("YYYY") >= 0) {
                line = line.replace("YYYY", "\\E[-0-9, ]+\\Q");
            }
            copyright.append(line).append('\n');
        }
        return copyright.toString();
    }

    private static Pattern getNonjavaCopyrightPattern(String name) throws IOException {
        String copyright = AbstractCopyright.readCopyright(name, true);
        return Pattern.compile(copyright.toString(), 8);
    }

    private static String getCopyrightText(String name) throws IOException {
        return AbstractCopyright.readCopyright(name, false);
    }

    private static String getCopyrightText(File file) throws IOException {
        return AbstractCopyright.readCopyright(file, false);
    }

    protected String lastChanged(String file) throws IOException {
        if (this.c.mercurial) {
            return AbstractCopyright.lastChangedHg(file);
        }
        if (this.c.git) {
            return AbstractCopyright.lastChangedGit(file);
        }
        return AbstractCopyright.lastChangedSvn(file);
    }

    private static String lastChangedSvn(String file) throws IOException {
        String line;
        String lastChangedDate = "Last Changed Date: ";
        String addedFile = "Schedule: add";
        ProcessBuilder pb = new ProcessBuilder("svn", "info", file);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String lcd = "";
        while ((line = r.readLine()) != null) {
            if (line.equals("Schedule: add")) {
                lcd = thisYear;
            }
            if (!line.startsWith("Last Changed Date: ")) continue;
            lcd = line.substring("Last Changed Date: ".length(), "Last Changed Date: ".length() + 4);
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return lcd;
    }

    private static String lastChangedHg(String file) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder("hg", "log", "--limit", "1", "--template", "{date|shortdate}", file);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String lcd = "";
        while ((line = r.readLine()) != null) {
            if (line.length() != 10 || !Character.isDigit(line.charAt(0))) continue;
            lcd = line.substring(0, 4);
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return lcd;
    }

    private static String lastChangedGit(String file) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder("git", "log", "-n", "1", "--date=local", file);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String lcd = "";
        while ((line = r.readLine()) != null) {
            if (!line.startsWith("Date:")) continue;
            String[] split = line.split(" ");
            lcd = split[split.length - 1];
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return lcd;
    }

    protected boolean isModified(String file) throws IOException {
        String line;
        ProcessBuilder pb = this.c.mercurial ? new ProcessBuilder("hg", "status", file) : new ProcessBuilder("svn", "status", file);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        boolean modified = false;
        while ((line = r.readLine()) != null) {
            if (!line.startsWith("M") && !line.startsWith("A")) continue;
            modified = true;
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return modified;
    }

    protected void err(String s) {
        if (!this.c.quiet) {
            System.out.println(s);
        }
        ++this.c.errors;
    }

    static {
        ypat = Pattern.compile("Copyright (\\(c\\) )?([-0-9, ]+) [A-Z]");
        endPat = Pattern.compile(" *\\*/");
        secLicPat = Pattern.compile("^.*This file incorporates work covered by", 8);
        crpat = Pattern.compile("YYYY.*$", 8);
        cspat = Pattern.compile("(\\b[Cc]opyright\\b|\\([Cc]\\))", 8);
        bsdpat = Pattern.compile("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS", 8);
        thisYear = "" + Calendar.getInstance().get(1);
        try {
            correctBSDCopyright = AbstractCopyright.getCopyrightText("bsd-copyright.txt");
            sunpat = AbstractCopyright.getCopyrightPattern("sun-cddl+gpl+ce-copyright.txt");
            apat = AbstractCopyright.getCopyrightPattern("cddl+gpl+ce+apache-copyright.txt");
            sunapat = AbstractCopyright.getCopyrightPattern("sun-cddl+gpl+ce+apache-copyright.txt");
            anewpat = AbstractCopyright.getCopyrightPattern("cddl+gpl+ce+apachenew-copyright.txt");
            sunanewpat = AbstractCopyright.getCopyrightPattern("sun-cddl+gpl+ce+apachenew-copyright.txt");
            mitspat = AbstractCopyright.getCopyrightPattern("cddl+gpl+ce+mitsallings-copyright.txt");
            bpat = AbstractCopyright.getCopyrightPattern("bsd-copyright.txt");
            anpat = AbstractCopyright.getCopyrightPattern("apache-copyright.txt");
            oapat = AbstractCopyright.getCopyrightPattern("oracle-apache-copyright.txt");
            sunbpat = AbstractCopyright.getCopyrightPattern("sun-bsd-copyright.txt");
            cnocepat = AbstractCopyright.getCopyrightPattern("cddl+gpl-copyright.txt");
            ocpat = AbstractCopyright.getCopyrightPattern("cddl-copyright.txt");
            oc2pat = AbstractCopyright.getCopyrightPattern("cddl2-copyright.txt");
            njcpat = AbstractCopyright.getNonjavaCopyrightPattern("cddl+gpl+ce-copyright.txt");
        }
        catch (IOException ex) {
            throw new RuntimeException("Copyright resource missing", ex);
        }
    }

    static enum RepairType {
        MISSING,
        WRONG,
        DATE;

    }
}

