/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.scope.SchemaRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.AlgorithmInUsedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.parser.statement.DropShadowAlgorithmStatement;

public final class DropShadowAlgorithmStatementUpdater
implements RuleDefinitionDropUpdater<DropShadowAlgorithmStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public void checkSQLStatement(ShardingSphereMetaData metaData, DropShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = metaData.getName();
        this.checkConfigurationExist(schemaName, (SchemaRuleConfiguration)currentRuleConfig);
        this.checkAlgorithm(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkConfigurationExist(String schemaName, SchemaRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShadowRuleStatementChecker.checkConfigurationExist(schemaName, currentRuleConfig);
    }

    private void checkAlgorithm(String schemaName, DropShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        List<String> currentAlgorithms = ShadowRuleStatementSupporter.getAlgorithmNames(currentRuleConfig);
        Collection requireAlgorithms = sqlStatement.getAlgorithmNames();
        ShadowRuleStatementChecker.checkAlgorithmExist(requireAlgorithms, currentAlgorithms, different -> new RequiredAlgorithmMissedException(SHADOW, schemaName, (Collection)different));
        this.checkAlgorithmInUsed(requireAlgorithms, this.getAlgorithmInUse(currentRuleConfig), identical -> new AlgorithmInUsedException(schemaName, (Collection)identical));
    }

    private void checkAlgorithmInUsed(Collection<String> requireAlgorithms, Collection<String> currentAlgorithms, Function<Set<String>, DistSQLException> thrower) throws DistSQLException {
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithms, currentAlgorithms, thrower);
    }

    private Set<String> getAlgorithmInUse(ShadowRuleConfiguration currentRuleConfig) {
        return currentRuleConfig.getTables().values().stream().filter(each -> !each.getDataSourceNames().isEmpty()).map(ShadowTableConfiguration::getShadowAlgorithmNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean updateCurrentRuleConfiguration(DropShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) {
        Collection algorithmNames = sqlStatement.getAlgorithmNames();
        algorithmNames.forEach(each -> {
            ShardingSphereAlgorithmConfiguration cfr_ignored_0 = (ShardingSphereAlgorithmConfiguration)currentRuleConfig.getShadowAlgorithms().remove(each);
        });
        currentRuleConfig.getTables().forEach((key, value) -> value.getShadowAlgorithmNames().removeIf(algorithmNames::contains));
        this.getEmptyTableRules(currentRuleConfig.getTables()).forEach(each -> {
            ShadowTableConfiguration cfr_ignored_0 = (ShadowTableConfiguration)currentRuleConfig.getTables().remove(each);
        });
        return false;
    }

    private Set<String> getEmptyTableRules(Map<String, ShadowTableConfiguration> tables) {
        return tables.entrySet().stream().filter(entry -> ((ShadowTableConfiguration)entry.getValue()).getShadowAlgorithmNames().isEmpty() && ((ShadowTableConfiguration)entry.getValue()).getDataSourceNames().isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return DropShadowAlgorithmStatement.class.getCanonicalName();
    }
}

