/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.routeinfo;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.QueueData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.namesrv.routeinfo.BrokerLiveInfo;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteInfoManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
    private static final long BROKER_CHANNEL_EXPIRED_TIME = 120000L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final HashMap<String, List<QueueData>> topicQueueTable = new HashMap(1024);
    private final HashMap<String, BrokerData> brokerAddrTable = new HashMap(128);
    private final HashMap<String, Set<String>> clusterAddrTable = new HashMap(32);
    private final HashMap<String, BrokerLiveInfo> brokerLiveTable = new HashMap(256);
    private final HashMap<String, List<String>> filterServerTable = new HashMap(256);

    public byte[] getAllClusterInfo() {
        ClusterInfo clusterInfoSerializeWrapper = new ClusterInfo();
        clusterInfoSerializeWrapper.setBrokerAddrTable(this.brokerAddrTable);
        clusterInfoSerializeWrapper.setClusterAddrTable(this.clusterAddrTable);
        return clusterInfoSerializeWrapper.encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTopic(String topic) {
        try {
            try {
                this.lock.writeLock().lockInterruptibly();
                this.topicQueueTable.remove(topic);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("deleteTopic Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAllTopicList() {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                topicList.getTopicList().addAll(this.topicQueueTable.keySet());
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList.encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterBrokerResult registerBroker(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, Channel channel) {
        RegisterBrokerResult result = new RegisterBrokerResult();
        try {
            try {
                BrokerLiveInfo brokerLiveInfo;
                String masterAddr;
                BrokerLiveInfo prevBrokerLiveInfo;
                ConcurrentMap tcTable;
                this.lock.writeLock().lockInterruptibly();
                Set<String> brokerNames = this.clusterAddrTable.get(clusterName);
                if (null == brokerNames) {
                    brokerNames = new HashSet<String>();
                    this.clusterAddrTable.put(clusterName, brokerNames);
                }
                brokerNames.add(brokerName);
                boolean registerFirst = false;
                BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                if (null == brokerData) {
                    registerFirst = true;
                    brokerData = new BrokerData(clusterName, brokerName, new HashMap());
                    this.brokerAddrTable.put(brokerName, brokerData);
                }
                String oldAddr = brokerData.getBrokerAddrs().put(brokerId, brokerAddr);
                boolean bl = registerFirst = registerFirst || null == oldAddr;
                if (null != topicConfigWrapper && 0L == brokerId && (this.isBrokerTopicConfigChanged(brokerAddr, topicConfigWrapper.getDataVersion()) || registerFirst) && (tcTable = topicConfigWrapper.getTopicConfigTable()) != null) {
                    for (Map.Entry entry : tcTable.entrySet()) {
                        this.createAndUpdateQueueData(brokerName, (TopicConfig)entry.getValue());
                    }
                }
                if (null == (prevBrokerLiveInfo = this.brokerLiveTable.put(brokerAddr, new BrokerLiveInfo(System.currentTimeMillis(), topicConfigWrapper.getDataVersion(), channel, haServerAddr)))) {
                    log.info("new broker registered, {} HAServer: {}", (Object)brokerAddr, (Object)haServerAddr);
                }
                if (filterServerList != null) {
                    if (filterServerList.isEmpty()) {
                        this.filterServerTable.remove(brokerAddr);
                    } else {
                        this.filterServerTable.put(brokerAddr, filterServerList);
                    }
                }
                if (0L != brokerId && (masterAddr = (String)brokerData.getBrokerAddrs().get(0L)) != null && (brokerLiveInfo = this.brokerLiveTable.get(masterAddr)) != null) {
                    result.setHaServerAddr(brokerLiveInfo.getHaServerAddr());
                    result.setMasterAddr(masterAddr);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("registerBroker Exception", (Throwable)e);
        }
        return result;
    }

    private boolean isBrokerTopicConfigChanged(String brokerAddr, DataVersion dataVersion) {
        BrokerLiveInfo prev = this.brokerLiveTable.get(brokerAddr);
        return null == prev || !prev.getDataVersion().equals((Object)dataVersion);
    }

    private void createAndUpdateQueueData(String brokerName, TopicConfig topicConfig) {
        QueueData queueData = new QueueData();
        queueData.setBrokerName(brokerName);
        queueData.setWriteQueueNums(topicConfig.getWriteQueueNums());
        queueData.setReadQueueNums(topicConfig.getReadQueueNums());
        queueData.setPerm(topicConfig.getPerm());
        queueData.setTopicSynFlag(topicConfig.getTopicSysFlag());
        List<QueueData> queueDataList = this.topicQueueTable.get(topicConfig.getTopicName());
        if (null == queueDataList) {
            queueDataList = new LinkedList<QueueData>();
            queueDataList.add(queueData);
            this.topicQueueTable.put(topicConfig.getTopicName(), queueDataList);
            log.info("new topic registered, {} {}", (Object)topicConfig.getTopicName(), (Object)queueData);
        } else {
            boolean addNewOne = true;
            Iterator<QueueData> it = queueDataList.iterator();
            while (it.hasNext()) {
                QueueData qd = it.next();
                if (!qd.getBrokerName().equals(brokerName)) continue;
                if (qd.equals((Object)queueData)) {
                    addNewOne = false;
                    continue;
                }
                log.info("topic changed, {} OLD: {} NEW: {}", new Object[]{topicConfig.getTopicName(), qd, queueData});
                it.remove();
            }
            if (addNewOne) {
                queueDataList.add(queueData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int wipeWritePermOfBrokerByLock(String brokerName) {
        try {
            this.lock.writeLock().lockInterruptibly();
            int n = this.wipeWritePermOfBroker(brokerName);
            this.lock.writeLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.writeLock().unlock();
                throw throwable;
            }
            catch (Exception e) {
                log.error("wipeWritePermOfBrokerByLock Exception", (Throwable)e);
                return 0;
            }
        }
    }

    private int wipeWritePermOfBroker(String brokerName) {
        int wipeTopicCnt = 0;
        for (Map.Entry<String, List<QueueData>> entry : this.topicQueueTable.entrySet()) {
            List<QueueData> qdList = entry.getValue();
            for (QueueData qd : qdList) {
                if (!qd.getBrokerName().equals(brokerName)) continue;
                int perm = qd.getPerm();
                qd.setPerm(perm &= 0xFFFFFFFD);
                ++wipeTopicCnt;
            }
        }
        return wipeTopicCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBroker(String clusterName, String brokerAddr, String brokerName, long brokerId) {
        try {
            try {
                this.lock.writeLock().lockInterruptibly();
                BrokerLiveInfo brokerLiveInfo = this.brokerLiveTable.remove(brokerAddr);
                log.info("unregisterBroker, remove from brokerLiveTable {}, {}", (Object)(brokerLiveInfo != null ? "OK" : "Failed"), (Object)brokerAddr);
                this.filterServerTable.remove(brokerAddr);
                boolean removeBrokerName = false;
                BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                if (null != brokerData) {
                    String addr = (String)brokerData.getBrokerAddrs().remove(brokerId);
                    log.info("unregisterBroker, remove addr from brokerAddrTable {}, {}", (Object)(addr != null ? "OK" : "Failed"), (Object)brokerAddr);
                    if (brokerData.getBrokerAddrs().isEmpty()) {
                        this.brokerAddrTable.remove(brokerName);
                        log.info("unregisterBroker, remove name from brokerAddrTable OK, {}", (Object)brokerName);
                        removeBrokerName = true;
                    }
                }
                if (removeBrokerName) {
                    Set<String> nameSet = this.clusterAddrTable.get(clusterName);
                    if (nameSet != null) {
                        boolean removed = nameSet.remove(brokerName);
                        log.info("unregisterBroker, remove name from clusterAddrTable {}, {}", (Object)(removed ? "OK" : "Failed"), (Object)brokerName);
                        if (nameSet.isEmpty()) {
                            this.clusterAddrTable.remove(clusterName);
                            log.info("unregisterBroker, remove cluster from clusterAddrTable {}", (Object)clusterName);
                        }
                    }
                    this.removeTopicByBrokerName(brokerName);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("unregisterBroker Exception", (Throwable)e);
        }
    }

    private void removeTopicByBrokerName(String brokerName) {
        Iterator<Map.Entry<String, List<QueueData>>> itMap = this.topicQueueTable.entrySet().iterator();
        while (itMap.hasNext()) {
            Map.Entry<String, List<QueueData>> entry = itMap.next();
            String topic = entry.getKey();
            List<QueueData> queueDataList = entry.getValue();
            Iterator<QueueData> it = queueDataList.iterator();
            while (it.hasNext()) {
                QueueData qd = it.next();
                if (!qd.getBrokerName().equals(brokerName)) continue;
                log.info("removeTopicByBrokerName, remove one broker's topic {} {}", (Object)topic, (Object)qd);
                it.remove();
            }
            if (!queueDataList.isEmpty()) continue;
            log.info("removeTopicByBrokerName, remove the topic all queue {}", (Object)topic);
            itMap.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicRouteData pickupTopicRouteData(String topic) {
        TopicRouteData topicRouteData = new TopicRouteData();
        boolean foundQueueData = false;
        boolean foundBrokerData = false;
        HashSet<String> brokerNameSet = new HashSet<String>();
        LinkedList<BrokerData> brokerDataList = new LinkedList<BrokerData>();
        topicRouteData.setBrokerDatas(brokerDataList);
        HashMap<String, List<String>> filterServerMap = new HashMap<String, List<String>>();
        topicRouteData.setFilterServerTable(filterServerMap);
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                List<QueueData> queueDataList = this.topicQueueTable.get(topic);
                if (queueDataList != null) {
                    topicRouteData.setQueueDatas(queueDataList);
                    foundQueueData = true;
                    for (QueueData qd : queueDataList) {
                        brokerNameSet.add(qd.getBrokerName());
                    }
                    for (String brokerName : brokerNameSet) {
                        BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                        if (null == brokerData) continue;
                        BrokerData brokerDataClone = new BrokerData(brokerData.getCluster(), brokerData.getBrokerName(), (HashMap)brokerData.getBrokerAddrs().clone());
                        brokerDataList.add(brokerDataClone);
                        foundBrokerData = true;
                        for (String brokerAddr : brokerDataClone.getBrokerAddrs().values()) {
                            List<String> filterServerList = this.filterServerTable.get(brokerAddr);
                            filterServerMap.put(brokerAddr, filterServerList);
                        }
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("pickupTopicRouteData Exception", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("pickupTopicRouteData {} {}", (Object)topic, (Object)topicRouteData);
        }
        if (foundBrokerData && foundQueueData) {
            return topicRouteData;
        }
        return null;
    }

    public void scanNotActiveBroker() {
        Iterator<Map.Entry<String, BrokerLiveInfo>> it = this.brokerLiveTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, BrokerLiveInfo> next = it.next();
            long last = next.getValue().getLastUpdateTimestamp();
            if (last + 120000L >= System.currentTimeMillis()) continue;
            RemotingUtil.closeChannel((Channel)next.getValue().getChannel());
            it.remove();
            log.warn("The broker channel expired, {} {}ms", (Object)next.getKey(), (Object)120000L);
            this.onChannelDestroy(next.getKey(), next.getValue().getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelDestroy(String remoteAddr, Channel channel) {
        String brokerAddrFound = null;
        if (channel != null) {
            try {
                try {
                    this.lock.readLock().lockInterruptibly();
                    for (Map.Entry<String, BrokerLiveInfo> entry : this.brokerLiveTable.entrySet()) {
                        if (entry.getValue().getChannel() != channel) continue;
                        brokerAddrFound = entry.getKey();
                        break;
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("onChannelDestroy Exception", (Throwable)e);
            }
        }
        if (null == brokerAddrFound) {
            brokerAddrFound = remoteAddr;
        } else {
            log.info("the broker's channel destroyed, {}, clean it's data structure at once", (Object)brokerAddrFound);
        }
        if (brokerAddrFound != null && brokerAddrFound.length() > 0) {
            try {
                try {
                    Map.Entry<String, Collection<String>> entry;
                    this.lock.writeLock().lockInterruptibly();
                    this.brokerLiveTable.remove(brokerAddrFound);
                    this.filterServerTable.remove(brokerAddrFound);
                    String brokerNameFound = null;
                    boolean removeBrokerName = false;
                    Iterator<Map.Entry<String, BrokerData>> itBrokerAddrTable = this.brokerAddrTable.entrySet().iterator();
                    while (itBrokerAddrTable.hasNext() && null == brokerNameFound) {
                        BrokerData brokerData = itBrokerAddrTable.next().getValue();
                        Iterator it = brokerData.getBrokerAddrs().entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry2 = it.next();
                            Long brokerId = (Long)entry2.getKey();
                            String brokerAddr = (String)entry2.getValue();
                            if (!brokerAddr.equals(brokerAddrFound)) continue;
                            brokerNameFound = brokerData.getBrokerName();
                            it.remove();
                            log.info("remove brokerAddr[{}, {}] from brokerAddrTable, because channel destroyed", (Object)brokerId, (Object)brokerAddr);
                            break;
                        }
                        if (!brokerData.getBrokerAddrs().isEmpty()) continue;
                        removeBrokerName = true;
                        itBrokerAddrTable.remove();
                        log.info("remove brokerName[{}] from brokerAddrTable, because channel destroyed", (Object)brokerData.getBrokerName());
                    }
                    if (brokerNameFound != null && removeBrokerName) {
                        Iterator<Map.Entry<String, Set<String>>> it = this.clusterAddrTable.entrySet().iterator();
                        while (it.hasNext()) {
                            entry = it.next();
                            String clusterName = entry.getKey();
                            Set brokerNames = (Set)entry.getValue();
                            boolean removed = brokerNames.remove(brokerNameFound);
                            if (!removed) continue;
                            log.info("remove brokerName[{}], clusterName[{}] from clusterAddrTable, because channel destroyed", brokerNameFound, (Object)clusterName);
                            if (!brokerNames.isEmpty()) break;
                            log.info("remove the clusterName[{}] from clusterAddrTable, because channel destroyed and no broker in this cluster", (Object)clusterName);
                            it.remove();
                            break;
                        }
                    }
                    if (removeBrokerName) {
                        Iterator<Map.Entry<String, List<QueueData>>> itTopicQueueTable = this.topicQueueTable.entrySet().iterator();
                        while (itTopicQueueTable.hasNext()) {
                            entry = itTopicQueueTable.next();
                            String topic = entry.getKey();
                            List queueDataList = (List)entry.getValue();
                            Iterator itQueueData = queueDataList.iterator();
                            while (itQueueData.hasNext()) {
                                QueueData queueData = (QueueData)itQueueData.next();
                                if (!queueData.getBrokerName().equals(brokerNameFound)) continue;
                                itQueueData.remove();
                                log.info("remove topic[{} {}], from topicQueueTable, because channel destroyed", (Object)topic, (Object)queueData);
                            }
                            if (!queueDataList.isEmpty()) continue;
                            itTopicQueueTable.remove();
                            log.info("remove topic[{}] all queue, from topicQueueTable, because channel destroyed", (Object)topic);
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("onChannelDestroy Exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAllPeriodically() {
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                log.info("--------------------------------------------------------");
                log.info("topicQueueTable SIZE: {}", (Object)this.topicQueueTable.size());
                for (Map.Entry<String, List<QueueData>> entry : this.topicQueueTable.entrySet()) {
                    log.info("topicQueueTable Topic: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("brokerAddrTable SIZE: {}", (Object)this.brokerAddrTable.size());
                for (Map.Entry<String, List<QueueData>> entry : this.brokerAddrTable.entrySet()) {
                    log.info("brokerAddrTable brokerName: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("brokerLiveTable SIZE: {}", (Object)this.brokerLiveTable.size());
                for (Map.Entry<String, Object> entry : this.brokerLiveTable.entrySet()) {
                    log.info("brokerLiveTable brokerAddr: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("clusterAddrTable SIZE: {}", (Object)this.clusterAddrTable.size());
                for (Map.Entry<String, Object> entry : this.clusterAddrTable.entrySet()) {
                    log.info("clusterAddrTable clusterName: {} {}", (Object)entry.getKey(), entry.getValue());
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("printAllPeriodically Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSystemTopicList() {
        TopicList topicList;
        block7: {
            topicList = new TopicList();
            try {
                try {
                    this.lock.readLock().lockInterruptibly();
                    for (Map.Entry<String, Set<String>> entry : this.clusterAddrTable.entrySet()) {
                        topicList.getTopicList().add(entry.getKey());
                        topicList.getTopicList().addAll((Collection)entry.getValue());
                    }
                    if (this.brokerAddrTable == null || this.brokerAddrTable.isEmpty()) break block7;
                    Iterator<String> it = this.brokerAddrTable.keySet().iterator();
                    while (it.hasNext()) {
                        BrokerData bd = this.brokerAddrTable.get(it.next());
                        HashMap brokerAddrs = bd.getBrokerAddrs();
                        if (brokerAddrs == null || brokerAddrs.isEmpty()) continue;
                        Iterator it2 = brokerAddrs.keySet().iterator();
                        topicList.setBrokerAddr((String)brokerAddrs.get(it2.next()));
                        break;
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("getAllTopicList Exception", (Throwable)e);
            }
        }
        return topicList.encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTopicsByCluster(String cluster) {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                Set<String> brokerNameSet = this.clusterAddrTable.get(cluster);
                for (String brokerName : brokerNameSet) {
                    block6: for (Map.Entry<String, List<QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                        String topic = topicEntry.getKey();
                        List<QueueData> queueDatas = topicEntry.getValue();
                        for (QueueData queueData : queueDatas) {
                            if (!brokerName.equals(queueData.getBrokerName())) continue;
                            topicList.getTopicList().add(topic);
                            continue block6;
                        }
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList.encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getUnitTopics() {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                for (Map.Entry<String, List<QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                    String topic = topicEntry.getKey();
                    List<QueueData> queueDatas = topicEntry.getValue();
                    if (queueDatas == null || queueDatas.size() <= 0 || !TopicSysFlag.hasUnitFlag((int)queueDatas.get(0).getTopicSynFlag())) continue;
                    topicList.getTopicList().add(topic);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList.encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHasUnitSubTopicList() {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                for (Map.Entry<String, List<QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                    String topic = topicEntry.getKey();
                    List<QueueData> queueDatas = topicEntry.getValue();
                    if (queueDatas == null || queueDatas.size() <= 0 || !TopicSysFlag.hasUnitSubFlag((int)queueDatas.get(0).getTopicSynFlag())) continue;
                    topicList.getTopicList().add(topic);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList.encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHasUnitSubUnUnitTopicList() {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                for (Map.Entry<String, List<QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                    String topic = topicEntry.getKey();
                    List<QueueData> queueDatas = topicEntry.getValue();
                    if (queueDatas == null || queueDatas.size() <= 0 || TopicSysFlag.hasUnitFlag((int)queueDatas.get(0).getTopicSynFlag()) || !TopicSysFlag.hasUnitSubFlag((int)queueDatas.get(0).getTopicSynFlag())) continue;
                    topicList.getTopicList().add(topic);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        return topicList.encode();
    }
}

