/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.grizzly;

import java.io.IOException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.grizzly.GrizzlyChannel;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class GrizzlyHandler
extends BaseFilter {
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyHandler.class);
    private final URL url;
    private final ChannelHandler handler;

    public GrizzlyHandler(URL url, ChannelHandler handler) {
        this.url = url;
        this.handler = handler;
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            this.handler.connected((Channel)channel);
        }
        catch (RemotingException e) {
            throw new IOException(StringUtils.toString((Throwable)e));
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnected(connection);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            this.handler.disconnected((Channel)channel);
        }
        catch (RemotingException e) {
            throw new IOException(StringUtils.toString((Throwable)e));
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnected(connection);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            this.handler.received((Channel)channel, ctx.getMessage());
        }
        catch (RemotingException e) {
            throw new IOException(StringUtils.toString((Throwable)e));
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnected(connection);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            this.handler.sent((Channel)channel, ctx.getMessage());
        }
        catch (RemotingException e) {
            throw new IOException(StringUtils.toString((Throwable)e));
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnected(connection);
        }
        return ctx.getInvokeAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            this.handler.caught((Channel)channel, error);
        }
        catch (RemotingException e) {
            logger.error("RemotingException on channel " + (Object)((Object)channel), (Throwable)e);
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnected(connection);
        }
    }
}

