/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.resolver;

import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.apache.bval.jsr.resolver.CachingRelevant;
import org.apache.bval.jsr.resolver.CachingTraversableResolver;
import org.apache.bval.jsr.resolver.DefaultTraversableResolver$org_apache_bval_util_reflection_Reflection$$getClass$$Ljava_lang_ClassLoader$Ljava_lang_String$_ACTION;
import org.apache.bval.jsr.resolver.DefaultTraversableResolver$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class DefaultTraversableResolver
implements TraversableResolver,
CachingRelevant {
    private static final Logger log;
    private static final boolean LOG_FINEST;
    private static final String PERSISTENCE_UTIL_CLASSNAME = "javax.persistence.PersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME = "org.apache.bval.jsr.resolver.JPATraversableResolver";
    private TraversableResolver jpaTR;

    public DefaultTraversableResolver() {
        this.initJpa();
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private void initJpa() {
        ClassLoader classLoader = DefaultTraversableResolver.org_apache_bval_util_reflection_Reflection$$getClassLoader(DefaultTraversableResolver.class);
        try {
            DefaultTraversableResolver.org_apache_bval_util_reflection_Reflection$$getClass(classLoader, PERSISTENCE_UTIL_CLASSNAME);
            if (LOG_FINEST) {
                log.log(Level.FINEST, String.format("Found %s on classpath.", PERSISTENCE_UTIL_CLASSNAME));
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, String.format("Cannot find %s on classpath. All properties will per default be traversable.", PERSISTENCE_UTIL_CLASSNAME));
            return;
        }
        try {
            Class jpaAwareResolverClass = ClassUtils.getClass((ClassLoader)classLoader, (String)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME, (boolean)true);
            this.jpaTR = (TraversableResolver)jpaAwareResolverClass.newInstance();
            if (LOG_FINEST) {
                log.log(Level.FINEST, String.format("Instantiated an instance of %s.", JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Unable to load or instantiate JPA aware resolver %s. All properties will per default be traversable.", JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME), e);
        }
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return DefaultTraversableResolver.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new DefaultTraversableResolver$org_apache_bval_util_reflection_Reflection$$getClassLoader$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$0(Class clazz) {
        return DefaultTraversableResolver.__privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? clazz.getClassLoader() : classLoader;
    }

    @Privileged
    private static /* synthetic */ Class<?> org_apache_bval_util_reflection_Reflection$$getClass(ClassLoader classLoader, String string) throws Exception {
        if (!(System.getSecurityManager() != null)) {
            return DefaultTraversableResolver.__privileged_org_apache_bval_util_reflection_Reflection$$getClass(classLoader, string);
        }
        try {
            return (Class)AccessController.doPrivileged(new DefaultTraversableResolver$org_apache_bval_util_reflection_Reflection$$getClass$$Ljava_lang_ClassLoader$Ljava_lang_String$_ACTION(classLoader, string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    static /* synthetic */ Class __privileged_access$1(ClassLoader classLoader, String string) throws Exception {
        return DefaultTraversableResolver.__privileged_org_apache_bval_util_reflection_Reflection$$getClass(classLoader, string);
    }

    private static /* synthetic */ Class<?> __privileged_org_apache_bval_util_reflection_Reflection$$getClass(ClassLoader classLoader, String string) throws Exception {
        return ClassUtils.getClass((ClassLoader)classLoader, (String)string, (boolean)true);
    }

    @Override
    public boolean needsCaching() {
        return this.jpaTR != null && CachingTraversableResolver.needsCaching(this.jpaTR);
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(DefaultTraversableResolver.class.getName());
        LOG_FINEST = log.isLoggable(Level.FINEST);
    }

    static {
        DefaultTraversableResolver.__privileged_clinit0();
    }
}

