/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.swagger;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kr.weitao.starter.util.swagger.SwaggerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.WildcardType;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConditionalOnProperty(prefix="swagger.ui", value={"enable"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SwaggerConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class SwaggerAutoConfiguration
extends WebMvcConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    @Autowired
    private SwaggerConfiguration props;
    @Autowired
    private TypeResolver typeResolver;

    @Bean
    public Docket api() {
        ApiInfo apiInfo = new ApiInfoBuilder().title(this.props.getTitle()).description(this.props.getDescription()).version(this.props.getVersion()).termsOfServiceUrl(this.props.getTermsOfServiceUrl()).contact(new Contact(this.props.getContact(), "https://weitao.kr/", "cloud@whale.com")).license(this.props.getLicense()).licenseUrl(this.props.getLicenseUrl()).build();
        AlternateTypeRule alternateTypeRule = AlternateTypeRules.newRule((Type)this.typeResolver.resolve(DeferredResult.class, new Type[]{this.typeResolver.resolve(ResponseEntity.class, new Type[]{WildcardType.class})}), (Type)this.typeResolver.resolve(WildcardType.class, new Type[0]));
        ArrayList responseMessages = Lists.newArrayList((Object[])new ResponseMessage[]{new ResponseMessageBuilder().code(500).message("500 internal server error").responseModel((ModelReference)new ModelRef("Error")).build()});
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.props.getGroup()).apiInfo(apiInfo).select().apis(RequestHandlerSelectors.any()).apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(this.excludedPathSelector()).build().pathMapping("/").directModelSubstitute(Date.class, String.class).genericModelSubstitutes(new Class[]{ResponseEntity.class}).alternateTypeRules(new AlternateTypeRule[]{alternateTypeRule}).useDefaultResponseMessages(false).globalResponseMessage(RequestMethod.GET, (List)responseMessages).forCodeGeneration(true).enableUrlTemplating(true);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars*"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true).ignoreUnknownPathExtensions(true).favorParameter(false).ignoreAcceptHeader(true).useJaf(false).defaultContentType(MediaType.APPLICATION_JSON);
        configurer.defaultContentTypeStrategy(nativeWebRequest -> {
            ArrayList<MediaType> medias = new ArrayList<MediaType>();
            medias.add(MediaType.APPLICATION_JSON);
            return medias;
        });
    }

    protected Predicate<String> excludedPathSelector() {
        if (Strings.isNullOrEmpty((String)this.props.getExcludes())) {
            return PathSelectors.any();
        }
        log.info("assembly excluded path selector as per config: {}", (Object)this.props.getExcludes());
        return Predicates.and((Iterable)Iterables.transform((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)this.props.getExcludes()), s -> Predicates.not((Predicate)PathSelectors.ant((String)s.trim()))));
    }
}

