/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.schema;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.rest.condition.EColumnAuthority;
import kr.weitao.starter.util.rest.query.GetSysConfigure;
import kr.weitao.starter.util.rest.schema.Column;
import kr.weitao.starter.util.rest.schema.ColumnImpl;
import kr.weitao.starter.util.rest.schema.Function;
import kr.weitao.starter.util.rest.schema.FunctionManager;
import kr.weitao.starter.util.rest.schema.T_SYS_COLUMN;
import kr.weitao.starter.util.rest.schema.T_SYS_FUNCTION;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FunctionImpl
implements Function {
    private static final Logger log = LoggerFactory.getLogger(FunctionImpl.class);
    private Column pkColumn;
    private T_SYS_FUNCTION table;
    private Function realTable;
    @Autowired
    private GetSysConfigure gsc;
    @Autowired
    private FunctionManager tableManager;

    @Override
    public void setFunction(T_SYS_FUNCTION t) {
        if (t == null) {
            throw new CommonException("-70", "\u521d\u59cb\u5316\u8868\u65f6\uff0c\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.table = t;
    }

    @Override
    public long getId() {
        return this.table.getId();
    }

    @Override
    public String getDBName() {
        return this.table.getFunction_name();
    }

    @Override
    public String getShowName() {
        return this.table.getShow_name();
    }

    @Override
    public void initData() {
    }

    @Override
    public Column getColumnByDBName(String dbName) {
        if (StringUtils.isNull((Object)dbName)) {
            throw new CommonException("-50", "\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        T_SYS_COLUMN column = null;
        JSONObject columnjo = this.gsc.getColumnByDBName(this.getId(), dbName);
        column = (T_SYS_COLUMN)JSONObject.parseObject((String)columnjo.toJSONString(), T_SYS_COLUMN.class);
        Column c = (Column)SpringUtils.getBean(ColumnImpl.class);
        c.setFunction(this);
        c.setColumn(column);
        return c;
    }

    @Override
    public List<Column> getUserColumns(long userId, EColumnAuthority e) {
        ArrayList<Column> userColumns = new ArrayList<Column>();
        JSONArray userColumnsja = this.gsc.getAuthorityColumns(this.table.getId(), userId, e);
        if (userColumnsja != null && userColumnsja.size() > 0) {
            int cuLength = userColumnsja.size();
            JSONObject tempColumn = null;
            long columnId = 0L;
            for (int i = 0; i < cuLength; ++i) {
                tempColumn = userColumnsja.getJSONObject(i);
                if (tempColumn == null || tempColumn.isEmpty()) {
                    log.error("-80", (Object)("user column index:" + i + " is null param:" + userColumnsja));
                    continue;
                }
                columnId = tempColumn.getLongValue(this.getPK().getDb_name());
                T_SYS_COLUMN column = null;
                JSONObject columnjo = this.gsc.getColumnById(columnId);
                column = (T_SYS_COLUMN)JSONObject.parseObject((String)columnjo.toJSONString(), T_SYS_COLUMN.class);
                Column c = (Column)SpringUtils.getBean(ColumnImpl.class);
                c.setFunction(this);
                c.setColumn(column);
                userColumns.add(c);
            }
        }
        return userColumns;
    }

    @Override
    public Column getPK() {
        if (this.pkColumn != null) {
            return this.pkColumn;
        }
        if (this.table.getPk_id() <= 0L) {
            log.error("table:" + this.table.getFunction_name() + " not set pk column");
            throw new CommonException("-70", "\u8868\uff1a" + this.table.getShow_name() + " \u6ca1\u6709\u7ef4\u62a4\u4e3b\u952e");
        }
        JSONObject columnjo = this.gsc.getColumnById(this.table.getPk_id());
        T_SYS_COLUMN column = (T_SYS_COLUMN)JSONObject.parseObject((String)columnjo.toJSONString(), T_SYS_COLUMN.class);
        this.pkColumn = (Column)SpringUtils.getBean(ColumnImpl.class);
        this.pkColumn.setFunction(this);
        this.pkColumn.setColumn(column);
        return this.pkColumn;
    }

    @Override
    public String getRealFunctionName() {
        if (this.table.getSys_function_id() == 0L) {
            return this.table.getFunction_name();
        }
        return this.getRealFunction().getDBName();
    }

    @Override
    public Function getRealFunction() {
        if (this.realTable != null) {
            return this.realTable;
        }
        if (this.table.getSys_function_id() > 0L) {
            this.realTable = this.tableManager.getById(this.table.getSys_function_id());
        }
        return this.realTable;
    }

    @Override
    public boolean getIsBc() {
        return "Y".equalsIgnoreCase(this.table.getIs_bc());
    }

    @Override
    public String getDataBCClassName() {
        return this.table.getBc_classname();
    }

    @Override
    public boolean getIsAc() {
        return "Y".equalsIgnoreCase(this.table.getIs_ac());
    }

    @Override
    public String getDataACClassName() {
        return this.table.getAc_classname();
    }

    @Override
    public boolean getIsBm() {
        return "Y".equalsIgnoreCase(this.table.getIs_bm());
    }

    @Override
    public String getDataBMClassName() {
        return this.table.getBm_classname();
    }

    @Override
    public boolean getIsAm() {
        return "Y".equalsIgnoreCase(this.table.getIs_am());
    }

    @Override
    public String getDataAMClassName() {
        return this.table.getAm_classname();
    }

    @Override
    public boolean getIsBd() {
        return "Y".equalsIgnoreCase(this.table.getIs_bd());
    }

    @Override
    public String getDataBDClassName() {
        return this.table.getBd_classname();
    }

    @Override
    public boolean getIsSubmit() {
        return "Y".equalsIgnoreCase(this.table.getIs_submit());
    }

    @Override
    public String getDataSubmitClassName() {
        return this.table.getSubmit_classname();
    }

    @Override
    public boolean getIsUnSubmit() {
        return "Y".equalsIgnoreCase(this.table.getIs_unsubmit());
    }

    @Override
    public String getUnSubmitClassName() {
        return this.table.getUnsummit_classname();
    }

    @Override
    public List<Column> getByDBNames(String dbNames) {
        ArrayList<Column> cs = new ArrayList<Column>();
        if (StringUtils.isNull((Object)dbNames)) {
            return cs;
        }
        String[] columDBNames = dbNames.split("\\s*,\\s*");
        int clength = columDBNames.length;
        String tempColumnName = null;
        for (int i = 0; i < clength; ++i) {
            Column c;
            tempColumnName = columDBNames[i];
            if (StringUtils.isNull((Object)tempColumnName) || (c = this.getColumnByDBName(tempColumnName)) == null) continue;
            cs.add(c);
        }
        return cs;
    }

    @Override
    public String getDataFrom() {
        return this.table.getData_from();
    }
}

