/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.rest.condition.EColumnAuthority;
import kr.weitao.starter.util.rest.dataengine.DataDisposeEngine;
import kr.weitao.starter.util.rest.dataengine.LogicExpression;
import kr.weitao.starter.util.rest.dataengine.OrganizeQuery;
import kr.weitao.starter.util.rest.query.GetSysConfigure;
import kr.weitao.starter.util.rest.schema.Column;
import kr.weitao.starter.util.rest.schema.Function;
import kr.weitao.starter.util.rest.schema.FunctionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Query {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    DataDisposeEngine dataDisposeEngine;
    @Autowired
    private FunctionManager functionManager;

    public void setFunctionManager(FunctionManager tm) {
        this.functionManager = tm;
    }

    public JSONObject queryArray(JSONObject param) throws CommonException {
        JSONObject resultjo = new JSONObject();
        List<Column> user_columns = null;
        List<Column> field_columns = null;
        Function table = null;
        long userId = 0L;
        if (param == null || param.isEmpty()) {
            log.error("param is null");
            throw new CommonException("-1", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!param.containsKey((Object)"user_id")) {
            log.error("param not has user_id,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        userId = param.getLongValue("user_id");
        if (userId == 0L) {
            log.error("param user_id error,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        if (!param.containsKey((Object)"function")) {
            log.error("data not has table key:" + param);
            throw new CommonException("-1", "\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        String table_name = param.getString("function");
        if (StringUtils.isNull((Object)table_name)) {
            log.error("data table is null:" + param);
            throw new CommonException("-1", "\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        table = this.functionManager.getByName(table_name);
        if (table == null) {
            log.error("data table object is null:" + param);
            throw new CommonException("-1", "\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        this.dataDisposeEngine = (DataDisposeEngine)SpringUtils.getBean((String)(table.getDataFrom() + "DataEngine"));
        String fieldNames = param.getString("field");
        if (StringUtils.isNotNull((Object)fieldNames)) {
            field_columns = table.getByDBNames(fieldNames);
        }
        if ((user_columns = table.getUserColumns(userId, EColumnAuthority.search)) == null || user_columns.size() <= 0) {
            log.error("user_columns is null,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        OrganizeQuery qq = OrganizeQuery.getInstance();
        LogicExpression le = qq.setCondition(param.getString("condition"));
        resultjo = this.dataDisposeEngine.getJSONArray(table, field_columns, le, param);
        return resultjo;
    }

    public JSONObject queryObject(JSONObject param) throws CommonException {
        JSONObject resultjo = new JSONObject();
        List<Column> user_columns = null;
        List<String> field_columnname = null;
        ArrayList<Column> search_columns = new ArrayList<Column>();
        Function table = null;
        long userId = 0L;
        if (param == null || param.isEmpty()) {
            log.error("param is null");
            throw new CommonException("-1", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!param.containsKey((Object)"user_id")) {
            log.error("param not has user_id,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        userId = param.getLongValue("user_id");
        if (userId == 0L) {
            log.error("param user_id error,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        if (!param.containsKey((Object)"function")) {
            log.error("data not has table key:" + param);
            throw new CommonException("-1", "\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        String table_name = param.getString("function");
        if (StringUtils.isNull((Object)table_name)) {
            log.error("data table is null:" + param);
            throw new CommonException("-1", "\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        table = this.functionManager.getByName(table_name);
        if (table == null) {
            log.error("data table object is null:" + param);
            throw new CommonException("-1", "\u4e1a\u52a1\u53c2\u6570\u9519\u8bef");
        }
        this.dataDisposeEngine = (DataDisposeEngine)SpringUtils.getBean((String)(table.getDataFrom() + "DataEngine"));
        String fieldNames = param.getString("field");
        if (StringUtils.isNotNull((Object)fieldNames)) {
            String[] fs = fieldNames.split("\\s*,\\s*");
            field_columnname = Arrays.asList(fs);
        }
        EColumnAuthority e = EColumnAuthority.search;
        if (param.containsKey((Object)"authcode")) {
            String authcode = param.getString("authcode");
            if ("1".equals(authcode)) {
                e = EColumnAuthority.create;
            }
            if ("3".equals(authcode)) {
                e = EColumnAuthority.modify;
            }
        }
        if ((user_columns = table.getUserColumns(userId, e)) == null || user_columns.size() <= 0) {
            log.error("redis user_columns is null,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        int uclength = user_columns.size();
        for (Column c : user_columns) {
            if (!field_columnname.contains(c.getDb_name())) continue;
            search_columns.add(c);
        }
        OrganizeQuery qq = OrganizeQuery.getInstance();
        LogicExpression le = qq.setCondition(param.getString("condition"));
        resultjo = this.dataDisposeEngine.getJSONObject(table, search_columns, le, param);
        return resultjo;
    }

    public JSONArray queryUserColumns(String function, long userId, String authCode) throws CommonException {
        long functionId = 0L;
        JSONArray userColumnja = null;
        if (StringUtils.isNull((Object)function)) {
            return userColumnja;
        }
        if (StringUtils.isDigital((String)function)) {
            functionId = Long.valueOf(function);
        } else {
            Function fun = this.functionManager.getByName(function);
            functionId = fun.getId();
        }
        GetSysConfigure gsc = (GetSysConfigure)SpringUtils.getBean(GetSysConfigure.class);
        EColumnAuthority eca = EColumnAuthority.getEColumnAuthority(authCode);
        if (eca == null) {
            throw new CommonException("-60", "\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        userColumnja = gsc.getAuthorityColumns(functionId, userId, eca);
        return userColumnja;
    }

    public JSONArray getUserSearchColumns(String function, long userId) {
        JSONArray searchColumnsja = null;
        long functionId = 0L;
        JSONArray userColumnja = null;
        if (StringUtils.isNull((Object)function)) {
            return userColumnja;
        }
        if (StringUtils.isDigital((String)function)) {
            functionId = Long.valueOf(function);
        } else {
            Function fun = this.functionManager.getByName(function);
            functionId = fun.getId();
        }
        GetSysConfigure gsc = (GetSysConfigure)SpringUtils.getBean(GetSysConfigure.class);
        searchColumnsja = gsc.getUserSearchColumns(functionId, userId);
        return searchColumnsja;
    }
}

