/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.rest.condition.EColumnAuthority;
import kr.weitao.starter.util.rest.condition.MysqlCondition;
import kr.weitao.starter.util.rest.dataengine.DataDisposeEngine;
import kr.weitao.starter.util.rest.datatrigger.DataAMTrigger;
import kr.weitao.starter.util.rest.datatrigger.DataBMTrigger;
import kr.weitao.starter.util.rest.query.ObjectCreateUtil;
import kr.weitao.starter.util.rest.schema.Column;
import kr.weitao.starter.util.rest.schema.Function;
import kr.weitao.starter.util.rest.schema.FunctionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class ObjectModifyUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectModifyUtil.class);
    @Autowired
    @Qualifier(value="mySQLDataEngine")
    DataDisposeEngine de;
    @Autowired
    private FunctionManager tableManager;

    @Transactional
    public long execute(JSONObject param, EColumnAuthority ec) throws CommonException {
        JSONObject tempMasterData;
        long id;
        List<Column> user_columns = null;
        Function table = null;
        JSONObject master_tableinfo = null;
        Object items = null;
        long modifyCount = 0L;
        long user_id = 0L;
        if (param == null || param.isEmpty()) {
            log.error("param is null");
            throw new CommonException("-1", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!param.containsKey((Object)"user_id")) {
            log.error("param not has user_id,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        user_id = param.getLongValue("user_id");
        if (user_id == 0L) {
            log.error("param user_id error,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        if (!param.containsKey((Object)"function")) {
            log.error("data not has table key:" + param);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        String table_name = param.getString("function");
        if (StringUtils.isNull((Object)table_name)) {
            log.error("data table is null:" + param);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        table = this.tableManager.getByName(table_name);
        if (table == null) {
            log.error("data table object is null:" + param);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        master_tableinfo = param.getJSONObject("master_object");
        if (master_tableinfo == null || master_tableinfo.isEmpty()) {
            log.error("master_object datainfo is null:" + param);
            throw new CommonException("-3", "\u8bf7\u7ef4\u62a4\u8981\u589e\u52a0\u7684\u6570\u636e");
        }
        JSONArray tempitems = param.getJSONArray("items");
        JSONObject tempiteminfo = null;
        if (tempitems != null && tempitems.size() > 0) {
            int ilength = tempitems.size();
            String tempforeignTable = null;
            String tempforeignColumn = null;
            for (int i = 0; i < ilength; ++i) {
                tempiteminfo = tempitems.getJSONObject(i);
                if (tempiteminfo == null || tempiteminfo.isEmpty()) continue;
                tempforeignTable = tempiteminfo.getString("foreign_object_name");
                if (StringUtils.isNull((Object)tempforeignTable)) {
                    log.error("item index:" + i + " foreign_object_name is null,param:" + param);
                    throw new CommonException("-3", "\u8bf7\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u8868");
                }
                tempforeignColumn = tempiteminfo.getString("foreign_field");
                if (StringUtils.isNull((Object)tempforeignColumn)) {
                    log.error("item index:" + i + " foreign_field is null,param:" + param);
                    throw new CommonException("-3", "\u8bf7\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u5b57\u6bb5");
                }
                items.add((Object)tempiteminfo);
            }
        }
        if ((user_columns = table.getUserColumns(user_id, ec)) == null || user_columns.size() <= 0) {
            log.error("redis user_columns is null,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        String bmclassname = table.getDataBMClassName();
        if (table.getIsBm() && StringUtils.isNotNull((Object)bmclassname)) {
            DataBMTrigger dataBMTrigger = null;
            try {
                Class<?> clazz = Class.forName(bmclassname);
                dataBMTrigger = clazz.isAnnotationPresent(Component.class) ? (DataBMTrigger)SpringUtils.getBean(clazz) : (DataBMTrigger)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("get DataBCTrigger instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("-80", "BM \u914d\u7f6e\u6709\u8bef");
            }
            dataBMTrigger.execute(table, param);
        }
        if ((id = (tempMasterData = param.getJSONObject("master_object")).getLongValue(table.getPK().getDb_name())) <= 0L) {
            log.error("modify data id error masterdata:" + tempMasterData.toJSONString());
            throw new CommonException("-80", "\u8bf7\u6b63\u786e\u7ef4\u62a4\u8981\u4fee\u6539\u7684\u6570\u636e\uff08\u4e3b\u952e\u6709\u8bef\uff09");
        }
        JSONObject modifyParam = new JSONObject();
        modifyParam.put("master_object", (Object)tempMasterData);
        modifyParam.put("user_id", (Object)param.getLongValue("user_id"));
        MysqlCondition mysqlConditeion = MysqlCondition.getInstance(table);
        modifyCount = this.de.update(mysqlConditeion.getUpdateSql(modifyParam, user_columns), mysqlConditeion.getUpdateDataParam());
        if (items != null && items.size() > 0) {
            Function tempfortable = null;
            Column tempforcolumn = null;
            JSONArray tempadd = null;
            JSONArray tempmodify = null;
            String tempforeignTableName = null;
            String tempforeignColumnName = null;
            int ilength = items.size();
            for (int i = 0; i < ilength; ++i) {
                int j;
                tempiteminfo = items.getJSONObject(i);
                if (tempiteminfo == null || tempiteminfo.isEmpty()) continue;
                tempforeignTableName = tempiteminfo.getString("foreign_object_name");
                if (StringUtils.isNull((Object)tempforeignTableName)) {
                    log.error("item index:" + i + " foreign_object_name is null,param:" + param);
                    throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u65b0\u589e\u7684\u660e\u7ec6\u8868\u6570\u636e");
                }
                tempfortable = this.tableManager.getByName(tempforeignTableName);
                if (tempfortable == null) {
                    log.error("item index:" + i + " not find foreign table by name:" + tempforeignTableName);
                    throw new CommonException("-90", "\u8bf7\u6b63\u786e\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u8868");
                }
                tempforeignColumnName = tempiteminfo.getString("foreign_field");
                if (StringUtils.isNull((Object)tempforeignColumnName)) {
                    log.error("item index:" + i + " foreign_field is null,param:" + param);
                    throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u5b57\u6bb5");
                }
                tempforcolumn = table.getColumnByDBName(tempforeignColumnName);
                if (tempforcolumn == null) {
                    log.error("item index:" + i + " not find foreign column by name:" + tempforeignColumnName);
                    throw new CommonException("-90", "\u8bf7\u6b63\u786e\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u5b57\u6bb5");
                }
                tempadd = tempiteminfo.getJSONArray("add_list");
                if (tempadd != null && tempadd.size() > 0) {
                    int alength = tempadd.size();
                    JSONObject tempAddInfo = null;
                    for (j = 0; j < alength; ++j) {
                        tempAddInfo = tempadd.getJSONObject(j);
                        if (tempAddInfo == null || tempAddInfo.isEmpty()) {
                            log.error("-80", (Object)("add foreign table:" + tempfortable.getShowName() + " data is null"));
                            throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u65b0\u589e\u7684\u660e\u7ec6\u8868\uff08" + tempfortable.getShowName() + "\uff09\u6570\u636e");
                        }
                        JSONObject createjo = new JSONObject();
                        createjo.put("function", (Object)tempforeignTableName);
                        createjo.put("master_object", (Object)tempAddInfo.getJSONObject("master_object"));
                        createjo.put("items", (Object)tempAddInfo.getJSONArray("items"));
                        createjo.put("user_id", (Object)user_id);
                        ((ObjectCreateUtil)SpringUtils.getBean(ObjectCreateUtil.class)).execute(createjo, EColumnAuthority.itemdate);
                    }
                }
                if ((tempmodify = tempiteminfo.getJSONArray("modify_list")) == null || tempmodify.size() <= 0) {
                    log.error("item index:" + i + " add_list is null,param:" + param);
                    throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u4fee\u6539\u7684\u660e\u7ec6\u8868\uff08" + tempfortable.getShowName() + "\uff09\u6570\u636e");
                }
                if (tempmodify == null || tempmodify.size() <= 0) continue;
                int mlength = tempmodify.size();
                JSONObject tempModifyInfo = null;
                for (j = 0; j < mlength; ++j) {
                    tempModifyInfo = tempmodify.getJSONObject(j);
                    if (tempModifyInfo == null || tempModifyInfo.isEmpty()) {
                        log.error("-80", (Object)("add foreign table:" + tempfortable.getShowName() + " data is null"));
                        throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u65b0\u589e\u7684\u660e\u7ec6\u8868\uff08" + tempfortable.getShowName() + "\uff09\u6570\u636e");
                    }
                    JSONObject modifyjo = new JSONObject();
                    modifyjo.put("function", (Object)tempforeignTableName);
                    modifyjo.put("master_object", (Object)tempModifyInfo.getJSONObject("master_object"));
                    modifyjo.put("items", (Object)tempModifyInfo.getJSONArray("items"));
                    modifyjo.put("user_id", (Object)user_id);
                    ((ObjectModifyUtil)SpringUtils.getBean(ObjectModifyUtil.class)).execute(modifyjo, EColumnAuthority.itemdate);
                }
            }
        }
        String amclassname = table.getDataAMClassName();
        if (table.getIsAm() && StringUtils.isNotNull((Object)amclassname)) {
            DataAMTrigger dataAMTrigger = null;
            try {
                Class<?> clazz = Class.forName(amclassname);
                dataAMTrigger = clazz.isAnnotationPresent(Component.class) ? (DataAMTrigger)SpringUtils.getBean(clazz) : (DataAMTrigger)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("get DataBCTrigger instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("-80", "BM \u914d\u7f6e\u6709\u8bef");
            }
            dataAMTrigger.execute(table, param);
        }
        return modifyCount;
    }
}

