/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.query;

import com.alibaba.fastjson.JSONObject;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.rest.dataengine.DataDisposeEngine;
import kr.weitao.starter.util.rest.datatrigger.DataBDTrigger;
import kr.weitao.starter.util.rest.schema.Function;
import kr.weitao.starter.util.rest.schema.FunctionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class ObjectDeleteUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectDeleteUtil.class);
    @Autowired
    @Qualifier(value="mySQLDataEngine")
    DataDisposeEngine de;
    @Autowired
    private FunctionManager tableManager;

    @Transactional
    public int execute(JSONObject param) throws CommonException {
        long id = 0L;
        int count = 0;
        Function table = null;
        String tableDBName = null;
        if (param == null || param.isEmpty()) {
            throw new CommonException("-1", "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e");
        }
        tableDBName = param.getString("function");
        if (StringUtils.isNull((Object)tableDBName)) {
            log.error("data table is null:" + param);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        table = this.tableManager.getByName(tableDBName);
        if (table == null) {
            log.error("data table object is null:" + tableDBName);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        id = param.getLongValue(table.getPK().getDb_name().toLowerCase());
        if (id <= 0L) {
            throw new CommonException("-1", "\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u6b63\u786e");
        }
        String bdclassname = table.getDataBDClassName();
        if (table.getIsBd() && StringUtils.isNotNull((Object)bdclassname)) {
            DataBDTrigger dataBDTrigger = null;
            try {
                Class<?> clazz = Class.forName(bdclassname);
                dataBDTrigger = clazz.isAnnotationPresent(Component.class) ? (DataBDTrigger)SpringUtils.getBean(clazz) : (DataBDTrigger)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("get DataBCTrigger instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("-80", "BM \u914d\u7f6e\u6709\u8bef");
            }
            dataBDTrigger.execute(table, param);
        }
        StringBuffer deleteSql = null;
        deleteSql = new StringBuffer("delete from ").append(table.getRealFunctionName());
        deleteSql.append(" where ").append(table.getPK().getDb_name());
        deleteSql.append(" =?");
        count = this.de.delete(deleteSql.toString(), new Object[]{id});
        return count;
    }
}

