/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.rest.condition.EColumnAuthority;
import kr.weitao.starter.util.rest.condition.MysqlCondition;
import kr.weitao.starter.util.rest.dataengine.DataDisposeEngine;
import kr.weitao.starter.util.rest.datatrigger.DataACTrigger;
import kr.weitao.starter.util.rest.datatrigger.DataBCTrigger;
import kr.weitao.starter.util.rest.schema.Column;
import kr.weitao.starter.util.rest.schema.Function;
import kr.weitao.starter.util.rest.schema.FunctionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class ObjectCreateUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectCreateUtil.class);
    @Autowired
    @Qualifier(value="mySQLDataEngine")
    DataDisposeEngine de;
    @Autowired
    private FunctionManager tableManager;

    @Transactional
    public long execute(JSONObject param, EColumnAuthority ec) throws CommonException {
        List<Column> user_columns = null;
        Function table = null;
        JSONObject master_tableinfo = null;
        Object items = null;
        long masterId = 0L;
        long user_id = 0L;
        if (param == null || param.isEmpty()) {
            log.error("param is null");
            throw new CommonException("-1", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!param.containsKey((Object)"user_id")) {
            log.error("param not has user_id,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        user_id = param.getLongValue("user_id");
        if (user_id == 0L) {
            log.error("param user_id error,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f");
        }
        if (!param.containsKey((Object)"function")) {
            log.error("data not has table key:" + param);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        String table_name = param.getString("function");
        if (StringUtils.isNull((Object)table_name)) {
            log.error("data table is null:" + param);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        table = this.tableManager.getByName(table_name);
        if (table == null) {
            log.error("data table object is null:" + param);
            throw new CommonException("-3", "\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u83dc\u5355");
        }
        master_tableinfo = param.getJSONObject("master_object");
        if (master_tableinfo == null || master_tableinfo.isEmpty()) {
            log.error("master_object datainfo is null:" + param);
            throw new CommonException("-3", "\u8bf7\u7ef4\u62a4\u8981\u589e\u52a0\u7684\u6570\u636e");
        }
        JSONArray tempitems = param.getJSONArray("items");
        JSONObject tempiteminfo = null;
        if (tempitems != null && tempitems.size() > 0) {
            int ilength = tempitems.size();
            String tempforeignTable = null;
            String tempforeignColumn = null;
            JSONArray tempadd = null;
            for (int i = 0; i < ilength; ++i) {
                tempiteminfo = tempitems.getJSONObject(i);
                if (tempiteminfo == null || tempiteminfo.isEmpty()) continue;
                tempforeignTable = tempiteminfo.getString("foreign_object_name");
                if (StringUtils.isNull((Object)tempforeignTable)) {
                    log.error("item index:" + i + " foreign_object_name is null,param:" + param);
                    throw new CommonException("-3", "\u8bf7\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u8868");
                }
                tempforeignColumn = tempiteminfo.getString("foreign_field");
                if (StringUtils.isNull((Object)tempforeignColumn)) {
                    log.error("item index:" + i + " foreign_field is null,param:" + param);
                    throw new CommonException("-3", "\u8bf7\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u5b57\u6bb5");
                }
                tempadd = tempiteminfo.getJSONArray("add_list");
                if (tempadd == null || tempadd.size() <= 0) {
                    log.error("item index:" + i + " add_list is null,param:" + param);
                    throw new CommonException("-3", "\u8bf7\u7ef4\u62a4\u8981\u65b0\u589e\u7684\u660e\u7ec6\u8868\u6570\u636e");
                }
                items.add((Object)tempiteminfo);
            }
        }
        if ((user_columns = table.getUserColumns(user_id, ec)) == null || user_columns.size() <= 0) {
            log.error("redis user_columns is null,param;" + param.toJSONString());
            throw new CommonException("-3", "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
        }
        String bcclassname = table.getDataBCClassName();
        if (table.getIsBc() && StringUtils.isNotNull((Object)bcclassname)) {
            DataBCTrigger dataBCTrigger = null;
            try {
                Class<?> clazz = Class.forName(bcclassname);
                dataBCTrigger = clazz.isAnnotationPresent(Component.class) ? (DataBCTrigger)SpringUtils.getBean(clazz) : (DataBCTrigger)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("get DataBCTrigger instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("-80", "BM \u914d\u7f6e\u6709\u8bef");
            }
            dataBCTrigger.execute(table, param);
        }
        JSONObject createParam = new JSONObject();
        createParam.put("master_object", (Object)param.getJSONObject("master_object"));
        createParam.put("user_id", (Object)param.getLongValue("user_id"));
        MysqlCondition mysqlConditeion = MysqlCondition.getInstance(table);
        masterId = this.de.insert(mysqlConditeion.getCreateSql(createParam, user_columns), mysqlConditeion.getCreateDataParam());
        param.put(table.getPK().getDb_name(), (Object)masterId);
        if (items != null && items.size() > 0) {
            Function tempfortable = null;
            Column tempforcolumn = null;
            JSONArray tempadd = null;
            String tempforeignTableName = null;
            String tempforeignColumnName = null;
            int ilength = items.size();
            for (int i = 0; i < ilength; ++i) {
                tempiteminfo = items.getJSONObject(i);
                if (tempiteminfo == null || tempiteminfo.isEmpty()) continue;
                tempforeignTableName = tempiteminfo.getString("foreign_object_name");
                if (StringUtils.isNull((Object)tempforeignTableName)) {
                    log.error("item index:" + i + " foreign_object_name is null,param:" + param);
                    throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u65b0\u589e\u7684\u660e\u7ec6\u8868\u6570\u636e");
                }
                tempfortable = this.tableManager.getByName(tempforeignTableName);
                if (tempfortable == null) {
                    log.error("item index:" + i + " not find foreign table by name:" + tempforeignTableName);
                    throw new CommonException("-90", "\u8bf7\u6b63\u786e\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u8868");
                }
                tempforeignColumnName = tempiteminfo.getString("foreign_field");
                if (StringUtils.isNull((Object)tempforeignColumnName)) {
                    log.error("item index:" + i + " foreign_field is null,param:" + param);
                    throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u5b57\u6bb5");
                }
                tempforcolumn = table.getColumnByDBName(tempforeignColumnName);
                if (tempforcolumn == null) {
                    log.error("item index:" + i + " not find foreign column by name:" + tempforeignColumnName);
                    throw new CommonException("-90", "\u8bf7\u6b63\u786e\u7ef4\u62a4\u8981\u64cd\u4f5c\u7684\u5173\u8054\u5b57\u6bb5");
                }
                tempadd = tempiteminfo.getJSONArray("add_list");
                if (tempadd == null || tempadd.size() <= 0) {
                    log.error("item index:" + i + " add_list is null,param:" + param);
                    throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u65b0\u589e\u7684\u660e\u7ec6\u8868\uff08" + tempfortable.getShowName() + "\uff09\u6570\u636e");
                }
                int alength = tempadd.size();
                JSONObject tempAddInfo = null;
                for (int j = 0; j < alength; ++j) {
                    tempAddInfo = tempadd.getJSONObject(j);
                    if (tempAddInfo == null || tempAddInfo.isEmpty()) {
                        log.error("-80", (Object)("add foreign table:" + tempfortable.getShowName() + " data is null"));
                        throw new CommonException("-90", "\u8bf7\u7ef4\u62a4\u8981\u65b0\u589e\u7684\u660e\u7ec6\u8868\uff08" + tempfortable.getShowName() + "\uff09\u6570\u636e");
                    }
                    JSONObject createjo = new JSONObject();
                    JSONObject tempForeignData = tempAddInfo.getJSONObject("master_object");
                    tempForeignData.put(tempforcolumn.getDb_name(), (Object)masterId);
                    createjo.put("function", (Object)tempforeignTableName);
                    createjo.put("master_object", (Object)tempForeignData);
                    createjo.put("items", (Object)tempAddInfo.getJSONArray("items"));
                    createjo.put("user_id", (Object)user_id);
                    ((ObjectCreateUtil)SpringUtils.getBean(ObjectCreateUtil.class)).execute(createjo, EColumnAuthority.itemdate);
                }
            }
        }
        String acclassname = table.getDataACClassName();
        if (table.getIsAc() && StringUtils.isNotNull((Object)acclassname)) {
            DataACTrigger dataACTrigger = null;
            try {
                Class<?> clazz = Class.forName(acclassname);
                dataACTrigger = clazz.isAnnotationPresent(Component.class) ? (DataACTrigger)SpringUtils.getBean(clazz) : (DataACTrigger)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("get DataBCTrigger instance error:" + e.getLocalizedMessage(), (Throwable)e);
                throw new CommonException("-80", "BM \u914d\u7f6e\u6709\u8bef");
            }
            dataACTrigger.execute(table, param);
        }
        return masterId;
    }
}

