/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kr.weitao.starter.util.jdbc.JdbcDataEngine;
import kr.weitao.starter.util.rest.condition.EColumnAuthority;
import kr.weitao.starter.util.rest.condition.ETableAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetSysConfigure {
    private static final Logger log = LoggerFactory.getLogger(GetSysConfigure.class);
    public static final GetSysConfigure getSc = new GetSysConfigure();
    private static final int authorityCode = 1024;
    @Autowired
    private JdbcDataEngine jdbcDataEngine;

    public static GetSysConfigure getInstance() {
        return getSc;
    }

    public JSONObject getTableById(long tableId) {
        JSONObject tablejo = this.jdbcDataEngine.getJdbcClient().getJSONObject("select st.id,st.def_corp_id,st.createid,st.createdate,st.modifyid,st.modifydate,st.is_ac,st.sort_no,st.is_show,st.img_default,st.img_hover,st.show_name,st.function_name,st.operate_rule,st.sys_function_id,st.pk_id,st.dk_id,st.ak_id,st.is_large,st.is_bc,st.bc_classname,st.is_ac,st.ac_classname,st.is_bm,st.bm_classname,st.is_am,st.am_classname,st.is_bd,st.bd_classname,st.is_submit,st.submit_classname,st.is_unsubmit,st.unsummit_classname,st.data_from,st.propertys,st.filter,st.sys_module_id,st.sys_function_category_id,st.sys_function_fold_id,st.is_cache from sys_function st where st.id=?", new Object[]{tableId});
        return tablejo;
    }

    public JSONObject getTableByDBName(String tableDBName) {
        JSONObject tablejo = this.jdbcDataEngine.getJdbcClient().getJSONObject("select st.id,st.def_corp_id,st.createid,st.createdate,st.modifyid,st.modifydate,st.is_ac,st.sort_no,st.is_show,st.img_default,st.img_hover,st.show_name,st.function_name,st.operate_rule,st.sys_function_id,st.pk_id,st.dk_id,st.ak_id,st.is_large,st.is_bc,st.bc_classname,st.is_ac,st.ac_classname,st.is_bm,st.bm_classname,st.is_am,st.am_classname,st.is_bd,st.bd_classname,st.is_submit,st.submit_classname,st.is_unsubmit,st.unsummit_classname,st.data_from,st.propertys,st.filter,st.sys_module_id,st.sys_function_category_id,st.sys_function_fold_id,st.is_cache from sys_function st where st.function_name=?", new Object[]{tableDBName});
        return tablejo;
    }

    public JSONObject getColumnById(long columnId) {
        JSONObject columnjo = this.jdbcDataEngine.getJdbcClient().getJSONObject("select c.id,c.def_corp_id,c.createid,c.createdate,c.modifyid,c.modifydate,c.is_active,c.show_name,c.field_name,c.by_name,c.sort_no,c.rwrule,c.voluation_type,c.show_type,c.statistics_type,c.cascade_type,c.sys_function_id,c.foreign_table_id,c.sys_sequence_id,c.sys_option_id,c.default_value,c.filter,c.is_showremark,c.remark,c.is_search,c.is_canorder,c.propertys,c.is_pk,c.is_dk,c.is_ak,c.is_nullable,c.is_cache,c.interpreter,c.max_length from sys_column c where c.id=?", new Object[]{columnId});
        return columnjo;
    }

    public JSONObject getColumnByDBName(long tableId, String columnDBName) {
        JSONObject columnjo = this.jdbcDataEngine.getJdbcClient().getJSONObject("select c.id,c.def_corp_id,c.createid,c.createdate,c.modifyid,c.modifydate,c.is_active,c.show_name,c.field_name,c.by_name,c.sort_no,c.rwrule,c.voluation_type,c.show_type,c.statistics_type,c.cascade_type,c.sys_function_id,c.foreign_table_id,c.sys_sequence_id,c.sys_option_id,c.default_value,c.filter,c.is_showremark,c.remark,c.is_search,c.is_canorder,c.propertys,c.is_pk,c.is_dk,c.is_ak,c.is_nullable,c.is_cache,c.interpreter,c.max_length from sys_column c where c.sys_function_id=? and c.field_name=?", new Object[]{tableId, columnDBName});
        return columnjo;
    }

    public JSONArray getColumnByTableId(long tableId) {
        JSONArray columnjo = this.jdbcDataEngine.getJdbcClient().getJSONArray("select c.id,c.def_corp_id,c.createid,c.createdate,c.modifyid,c.modifydate,c.is_active,c.show_name,c.field_name,c.by_name,c.sort_no,c.rwrule,c.voluation_type,c.show_type,c.statistics_type,c.cascade_type,c.sys_function_id,c.foreign_table_id,c.sys_sequence_id,c.sys_option_id,c.default_value,c.filter,c.is_showremark,c.remark,c.is_search,c.is_canorder,c.propertys,c.is_pk,c.is_dk,c.is_ak,c.is_nullable,c.is_cache,c.interpreter,c.max_length from sys_column c where c.sys_function_id=? and c.field_name=?", new Object[]{tableId});
        return columnjo;
    }

    public JSONArray getColumnByTableDBName(String tableDBName) {
        JSONArray columnjo = this.jdbcDataEngine.getJdbcClient().getJSONArray("select c.id,c.def_corp_id,c.createid,c.createdate,c.modifyid,c.modifydate,c.is_active,c.show_name,c.field_name,c.by_name,c.sort_no,c.rwrule,c.voluation_type,c.show_type,c.statistics_type,c.cascade_type,c.sys_function_id,c.foreign_table_id,c.sys_sequence_id,c.sys_option_id,c.default_value,c.filter,c.is_showremark,c.remark,c.is_search,c.is_canorder,c.propertys,c.is_pk,c.is_dk,c.is_ak,c.is_nullable,c.is_cache,c.interpreter,c.max_length from sys_column c where c.sys_function_id=? and c.field_name=?", new Object[]{tableDBName});
        return columnjo;
    }

    public JSONArray getAuthorityColumns(long tableId, long userId, EColumnAuthority eca) {
        JSONArray userAuthorityColumns = new JSONArray();
        String authcode = String.format("%010d", Integer.valueOf(Integer.toBinaryString(1024 >> eca.getValue())));
        authcode = authcode.replace("0", "_");
        userAuthorityColumns = this.jdbcDataEngine.getJdbcClient().getJSONArray("select c.id,c.def_corp_id,c.createid,c.createdate,c.modifyid,c.modifydate,c.is_active,c.show_name,c.field_name,c.max_length,c.by_name,c.sort_no,c.voluation_type,c.show_type,c.statistics_type,c.cascade_type,c.sys_function_id,c.foreign_table_id,c.sys_sequence_id,c.sys_option_id,c.default_value,c.filter,c.is_showremark,c.remark,c.is_search,c.is_canorder,c.propertys,c.is_pk,c.is_dk,c.is_ak,c.is_nullable,c.is_cache,c.interpreter,c.is_extend,c.platform_id,c.platform_type,c.data_from,ca.rwrule,ca.rwrule_terminal,c.position,c.group_name from def_function_authority dma join def_column_authority ca on ca.def_function_authority_id=dma.id join sys_column c on c.id=ca.sys_column_id where dma.sys_function_id=? and ca.is_active='Y' and (exists (select du.id from def_user du join def_role dr on du.def_role_ids regexp concat('(^|[:space:]+|[[:<:]])',dr.id,'([[:>:]]|[:space:]+|$)') where du.id=? and dma.def_role_ids regexp concat('(^|[:space:]+|[[:<:]])',dr.id,'([[:>:]]|[:space:]+|$)')) or dma.def_user_id=?) and ca.rwrule like ? order by ca.sort_no asc", new Object[]{tableId, userId, userId, authcode});
        return userAuthorityColumns;
    }

    public boolean checkAuthorityTable(long tableId, long userId, ETableAuthority eta) {
        boolean isAuthority = false;
        int count = 0;
        count = this.jdbcDataEngine.getJdbcClient().getCount("select count(1) from def_function_authority dma join sys_action da on dma.sys_action_ids regexp concat('(^|[:space:]+|[[:<:]])',da.id,'([[:>:]]|[:space:]+|$)') where dma.sys_function_id=? and (exists (select du.id from def_user du join def_role dr on du.def_role_ids regexp concat('(^|[:space:]+|[[:<:]])',dr.id,'([[:>:]]|[:space:]+|$)') where du.id=? and dma.def_role_ids regexp concat('(^|[:space:]+|[[:<:]])',dr.id,'([[:>:]]|[:space:]+|$)')) or dma.def_user_id=?) and da.code=?", new Object[]{tableId, userId, userId, eta.getValue()});
        isAuthority = count > 0;
        return isAuthority;
    }

    public JSONArray getUserSearchColumns(long functionId, long userId) {
        JSONArray searchColumnsja = this.jdbcDataEngine.getJdbcClient().getJSONArray("select c.id,c.def_corp_id,c.createid,c.createdate,c.modifyid,c.modifydate,c.is_active,c.show_name,c.field_name,c.max_length,c.by_name,c.sort_no,c.voluation_type,c.show_type,c.statistics_type,c.cascade_type,c.sys_function_id,c.foreign_table_id,c.sys_sequence_id,c.sys_option_id,c.default_value,c.filter,c.is_showremark,c.remark,c.is_search,c.is_canorder,c.propertys,c.is_pk,c.is_dk,c.is_ak,c.is_nullable,c.is_cache,c.interpreter,c.is_extend,c.platform_id,c.platform_type,c.data_from,ca.rwrule,ca.rwrule_terminal from def_function_authority dma join def_column_authority ca on ca.def_function_authority_id=dma.id join sys_column c on c.id=ca.sys_column_id where dma.sys_function_id=? and ca.is_active='Y' and (exists (select du.id from def_user du join def_role dr on du.def_role_ids regexp concat('(^|[:space:]+|[[:<:]])',dr.id,'([[:>:]]|[:space:]+|$)') where du.id=? and dma.def_role_ids regexp concat('(^|[:space:]+|[[:<:]])',dr.id,'([[:>:]]|[:space:]+|$)')) or dma.def_user_id=?) and c.is_search='Y' order by ca.sort_no asc", new Object[]{functionId, userId, userId});
        return searchColumnsja;
    }

    public JSONArray getOptions(long optionId) {
        JSONArray optionja = this.jdbcDataEngine.getJdbcClient().getJSONArray("select oi.id,oi.code,oi.name from sys_option_item oi where oi.sys_option_id=? order by oi.sort_no asc", new Object[]{optionId});
        return optionja;
    }
}

