/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.dataengine;

import com.alibaba.fastjson.JSONObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.rest.condition.ELogic;
import kr.weitao.starter.util.rest.dataengine.LogicExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizeQuery {
    private static final Logger log = LoggerFactory.getLogger(OrganizeQuery.class);
    private String condition = null;
    private JSONObject fractionCondition = new JSONObject();

    private OrganizeQuery() {
    }

    public static OrganizeQuery getInstance() {
        return new OrganizeQuery();
    }

    public LogicExpression setCondition(String condition) {
        this.condition = condition;
        return this.extractCondition();
    }

    private LogicExpression extractCondition() {
        if (StringUtils.isNull((Object)this.condition)) {
            return null;
        }
        String tempCondition = this.condition;
        tempCondition = tempCondition.replaceAll("(?<=\\s*\\(\\s*\\*[^\\)]+)\\)", "\u00a7r\u00a7");
        tempCondition = tempCondition.replaceAll("(?<=:)\\s*\\(\\s*\\*\\s*", "\u00a7l\u00a7");
        Pattern pp = Pattern.compile("(?<=\\((?=[^\\(\\)]+\\)))[^\\(\\)]+(?=\\))");
        Matcher mm = pp.matcher(tempCondition);
        int ecount = -1;
        String fString = "";
        while (mm.find()) {
            mm = pp.matcher(tempCondition);
            while (mm.find()) {
                fString = mm.group();
                this.fractionCondition.put("<<" + ++ecount + ">>", (Object)fString);
                tempCondition = tempCondition.replace("(" + fString + ")", "<<" + ecount + ">>");
                mm = pp.matcher(tempCondition);
            }
        }
        this.condition = tempCondition;
        return this.buildExpression(this.condition, ELogic.and);
    }

    public LogicExpression buildExpression(String extractCondition, ELogic el) {
        String splitChar = "";
        if (el == ELogic.and) {
            splitChar = "\\s+(AND|and|&&|&)\\s+";
        } else if (el == ELogic.or) {
            splitChar = "\\s+(OR|or|\\|\\||\\|)\\s+";
        }
        if (StringUtils.isNull((Object)extractCondition)) {
            return null;
        }
        String[] cs = extractCondition.split(splitChar);
        int elength = cs.length;
        LogicExpression exp = null;
        Pattern pp = null;
        Matcher mm = null;
        for (int i = 0; i < elength; ++i) {
            LogicExpression temple;
            String tempCondition = cs[i];
            if (StringUtils.isNull((Object)tempCondition)) {
                log.error("condition has null Express: " + extractCondition);
                continue;
            }
            pp = Pattern.compile("\\s+(OR|or|\\|\\||\\|)\\s+");
            mm = pp.matcher(tempCondition);
            if (mm.find()) {
                temple = this.buildExpression(tempCondition, ELogic.or);
                if (exp == null) {
                    exp = temple;
                    continue;
                }
                exp.addLogicExpression(temple, el);
                continue;
            }
            pp = Pattern.compile("\\s*<<\\d+>>\\s*");
            mm = pp.matcher(tempCondition);
            if (mm.find()) {
                if (exp == null) {
                    exp = new LogicExpression();
                }
                temple = this.buildExpression(this.fractionCondition.getString(tempCondition.trim()), ELogic.and);
                exp = exp.combine(temple, el);
                exp.setEl(el);
                continue;
            }
            exp = exp == null ? new LogicExpression(tempCondition, el) : exp.combine(new LogicExpression(tempCondition, el), el);
        }
        return exp;
    }
}

