/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.dataengine;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kr.weitao.starter.util.jdbc.JdbcDataEngine;
import kr.weitao.starter.util.rest.condition.MysqlCondition;
import kr.weitao.starter.util.rest.dataengine.DataDisposeEngine;
import kr.weitao.starter.util.rest.dataengine.LogicExpression;
import kr.weitao.starter.util.rest.schema.Column;
import kr.weitao.starter.util.rest.schema.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MySQLDataEngine
implements DataDisposeEngine {
    private static final Logger log = LoggerFactory.getLogger(MySQLDataEngine.class);
    @Autowired
    private JdbcDataEngine jdbcDataEngine;

    @Override
    public long insert(String sql, Object[] param) {
        return this.jdbcDataEngine.getJdbcClient().insert(sql, param);
    }

    @Override
    public int update(String sql, Object[] param) {
        return this.jdbcDataEngine.getJdbcClient().update(sql, param);
    }

    @Override
    public int delete(String sql, Object[] param) {
        return this.jdbcDataEngine.getJdbcClient().delete(sql, param);
    }

    @Override
    public JSONObject getJSONArray(Function function, List<Column> field, LogicExpression le, JSONObject param) {
        int pageSize;
        int pageNum;
        JSONObject resultjo = new JSONObject();
        if (param == null) {
            param = new JSONObject();
        }
        if ((pageNum = param.getIntValue("page_num")) < 0) {
            pageNum = 0;
        }
        if ((pageSize = param.getIntValue("page_size")) <= 0) {
            pageSize = 100;
        } else if (pageSize > 500) {
            pageSize = 100;
        }
        MysqlCondition cu = MysqlCondition.getInstance(function);
        cu.setCondition(le);
        String countSql = cu.getCountSql();
        int dataCount = this.jdbcDataEngine.getJdbcClient().getCount(countSql, cu.getQueryDataParam());
        int beginindex = pageNum * pageSize;
        int endindex = pageSize;
        int yc = dataCount % pageSize;
        int zc = dataCount / pageSize;
        if (dataCount <= beginindex) {
            if (yc > 0) {
                ++zc;
            }
            resultjo.put("total_count", (Object)dataCount);
            resultjo.put("page_count", (Object)zc);
            resultjo.put("list", (Object)new JSONArray());
            return resultjo;
        }
        if (dataCount < (pageNum + 1) * pageSize) {
            if (yc > 0) {
                endindex = yc;
            }
            beginindex = zc * pageSize;
        }
        if (yc > 0) {
            ++zc;
        }
        cu.setOrderBy(param.getJSONArray("order_by"));
        log.debug("----cu:" + param.getJSONArray("order_by"));
        cu.setPage(beginindex, endindex);
        JSONArray dataja = this.jdbcDataEngine.getJdbcClient().getJSONArray(cu.getQuerySql(field), cu.getQueryDataParam());
        resultjo.put("data_count", (Object)dataCount);
        resultjo.put("page_count", (Object)zc);
        resultjo.put("list", (Object)dataja);
        return resultjo;
    }

    @Override
    public JSONObject getJSONObject(Function function, List<Column> field, LogicExpression le, JSONObject param) {
        JSONObject resultjo = new JSONObject();
        if (param == null) {
            param = new JSONObject();
        }
        MysqlCondition cu = MysqlCondition.getInstance(function);
        cu.setCondition(le);
        cu.setOrderBy(param.getJSONArray("order_by"));
        cu.setPage(0, 1);
        JSONObject datajo = this.jdbcDataEngine.getJdbcClient().getJSONObject(cu.getQuerySql(field), cu.getQueryDataParam());
        return datajo;
    }
}

