/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.dataengine;

import java.util.ArrayList;
import java.util.List;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.rest.condition.ELogic;
import kr.weitao.starter.util.rest.condition.ERelation;
import kr.weitao.starter.util.rest.schema.T_SYS_COLUMN;

public class LogicExpression {
    private ELogic el;
    private RelationExpression rExpression;
    private List<LogicExpression> allExpression = new ArrayList<LogicExpression>();

    public LogicExpression() {
    }

    public LogicExpression(String condition, ELogic el) {
        if (StringUtils.isNull((Object)condition)) {
            throw new CommonException("-60", "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int index = condition.indexOf(":");
        if (index < 0) {
            throw new CommonException("-60", "\u6761\u4ef6\u9519\u8bef");
        }
        String columnCode = condition.substring(0, index);
        String value = condition.substring(index + 1);
        this.el = el;
        this.rExpression = new RelationExpression(columnCode, value, ERelation.range);
    }

    public LogicExpression(String columnDBName, String value, String ecode, ELogic el) {
        ERelation er = ERelation.getERelation(ecode);
        this.rExpression = new RelationExpression(columnDBName, value, er);
        this.el = el;
    }

    public LogicExpression(String columnDBName, String value, ERelation er, ELogic el) {
        this.rExpression = new RelationExpression(columnDBName, value, er);
        this.el = el;
    }

    public LogicExpression combine(LogicExpression le, ELogic el) {
        if (this.rExpression != null) {
            LogicExpression temple = new LogicExpression();
            temple.el = this.el;
            temple.rExpression = new RelationExpression(this.rExpression.columnDBName, this.rExpression.value, this.rExpression.comparison);
            this.rExpression = null;
            this.allExpression.add(temple);
            temple = this.combine(le, el);
            return temple;
        }
        le.el = el;
        this.allExpression.add(le);
        return this;
    }

    public String getDesc() {
        if (this.rExpression == null) {
            return "";
        }
        return this.rExpression.getDesc();
    }

    public T_SYS_COLUMN getColumn() {
        return this.rExpression.column;
    }

    public String getValue() {
        return this.rExpression.value;
    }

    public String getColumnDBName() {
        return this.rExpression.columnDBName;
    }

    public ERelation getERelation() {
        return this.rExpression.comparison;
    }

    public ELogic getEl() {
        return this.el;
    }

    public void setEl(ELogic el) {
        this.el = el;
    }

    public void addLogicExpression(LogicExpression le, ELogic el) {
        if (le == null) {
            return;
        }
        if (le.allExpression.size() > 0) {
            le.allExpression.get((int)0).el = el;
            if (this.rExpression != null) {
                LogicExpression temple = new LogicExpression();
                temple.el = this.el;
                temple.rExpression = new RelationExpression(this.rExpression.columnDBName, this.rExpression.value, this.rExpression.comparison);
                this.rExpression = null;
                this.allExpression.add(temple);
            }
            this.allExpression.addAll(le.getAllExpression());
            return;
        }
        this.combine(le, el);
    }

    public List<LogicExpression> getAllExpression() {
        return this.allExpression;
    }

    class RelationExpression {
        private ERelation comparison;
        private String columnDBName;
        private T_SYS_COLUMN column;
        private String value;
        private String desc;

        public RelationExpression(String columnDBName, String value, ERelation r) {
            if (StringUtils.isNull((Object)columnDBName)) {
                throw new CommonException("-50", "\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.columnDBName = columnDBName;
            if (StringUtils.isNotNull((Object)value)) {
                value = value.replaceAll("\u00a7l\u00a7", "(* ");
                value = value.replaceAll("\u00a7r\u00a7", ")");
            }
            this.value = value;
            this.comparison = r;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

