/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.condition;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.rest.condition.Condition;
import kr.weitao.starter.util.rest.condition.ERelation;
import kr.weitao.starter.util.rest.condition.EVoluationType;
import kr.weitao.starter.util.rest.dataengine.LogicExpression;
import kr.weitao.starter.util.rest.schema.Column;
import kr.weitao.starter.util.rest.schema.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(MysqlCondition.class);
    private Function masterTable;
    private QueryUtil qu = new QueryUtil();
    private CreateUtil cu = new CreateUtil();
    private UpdateUtil uu = new UpdateUtil();

    private MysqlCondition() {
    }

    public static MysqlCondition getInstance(Function masterTable) {
        MysqlCondition condition = new MysqlCondition();
        condition.masterTable = masterTable;
        return condition;
    }

    private void setSearchColumns(List<Column> columns) {
        this.qu.setSearchColumns(columns);
    }

    public void setLe(LogicExpression le) {
        this.qu.setLe(le);
    }

    @Override
    public Object[] getQueryDataParam() {
        return this.qu.dataParam.toArray(new Object[this.qu.dataParam.size()]);
    }

    @Override
    public void setOrderBy(JSONArray orderby) {
        this.qu.setOrderBy(orderby);
    }

    @Override
    public void setPage(int beginIndex, int endIndex) {
        this.qu.setPage(beginIndex, endIndex);
    }

    @Override
    public void setCondition(LogicExpression le) {
        this.setLe(le);
    }

    @Override
    public String getCreateSql(JSONObject dataParam, List<Column> userColumns) {
        return this.cu.getSql(dataParam, userColumns);
    }

    @Override
    public Object[] getCreateDataParam() {
        return this.cu.insertParam.toArray(new Object[this.qu.dataParam.size()]);
    }

    @Override
    public String getCountSql() {
        return this.qu.getCountSql();
    }

    @Override
    public String getQuerySql(List<Column> c) {
        this.setSearchColumns(c);
        return this.qu.getQuerySql();
    }

    @Override
    public String getUpdateSql(JSONObject dataParam, List<Column> userColumns) {
        return this.uu.getSql(dataParam, userColumns);
    }

    @Override
    public Object[] getUpdateDataParam() {
        return this.uu.modifyParam.toArray(new Object[this.qu.dataParam.size()]);
    }

    @Override
    public String getDeleteSql(JSONObject dataParam) {
        return null;
    }

    private class UpdateUtil {
        private List<Object> modifyParam = new ArrayList<Object>();

        private UpdateUtil() {
        }

        private String getSql(JSONObject dataParam, List<Column> userColumns) {
            if (dataParam == null || dataParam.isEmpty()) {
                log.error("create param is null");
                throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\u9700\u8981\u4fee\u6539\u7684\u6570\u636e");
            }
            JSONObject modifyData = dataParam.getJSONObject("master_object");
            if (modifyData == null || modifyData.isEmpty()) {
                log.error("master_object is null param:" + dataParam);
                throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\u9700\u8981\u4fee\u6539\u7684\u6570\u636e");
            }
            if (userColumns == null || userColumns.size() <= 0) {
                log.error("create columns is null param:" + dataParam);
                throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5");
            }
            StringBuffer modifySql = new StringBuffer();
            Object objValue = null;
            String tempValue = null;
            int clength = userColumns.size();
            Column tempColumn = null;
            for (int i = 0; i < clength; ++i) {
                tempValue = "?";
                tempColumn = userColumns.get(i);
                if (tempColumn == null) {
                    log.error("create user columns is null");
                    throw new CommonException("-50", "\u8981\u4fee\u6539\u6570\u636e\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!modifyData.containsKey((Object)tempColumn.getDb_name().toUpperCase()) && !modifyData.containsKey((Object)tempColumn.getDb_name().toLowerCase()) || tempColumn.getVoluationType() == EVoluationType.pk || tempColumn.getVoluationType() == EVoluationType.ignore || tempColumn.getVoluationType() == EVoluationType.creater || tempColumn.getVoluationType() == EVoluationType.createdatetime || tempColumn.getVoluationType() == EVoluationType.no) continue;
                objValue = modifyData.get((Object)tempColumn.getDb_name().toUpperCase());
                if (StringUtils.isNull((Object)objValue)) {
                    objValue = modifyData.get((Object)tempColumn.getDb_name().toLowerCase());
                }
                if (tempColumn.getVoluationType() == EVoluationType.createdatetime || tempColumn.getVoluationType() == EVoluationType.operatedatetime) {
                    tempValue = "now()";
                    objValue = tempValue;
                } else if (tempColumn.getVoluationType() == EVoluationType.creater || tempColumn.getVoluationType() == EVoluationType.operater) {
                    objValue = dataParam.getString("user_id");
                } else if (StringUtils.isNull((Object)objValue)) {
                    objValue = tempColumn.getDefaultValue();
                }
                if (!tempColumn.isNullable() && StringUtils.isNull((Object)objValue)) {
                    log.error("column:" + MysqlCondition.this.masterTable.getDBName() + "." + tempColumn.getDb_name() + " set is not null but value is null");
                    throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\uff1a" + tempColumn.getShow_name());
                }
                if (modifySql.length() > 0) {
                    modifySql.append(",");
                }
                if (StringUtils.isNull((Object)objValue)) {
                    tempValue = null;
                }
                modifySql.append(tempColumn.getDb_name()).append("=").append(tempValue);
                if (!"?".equals(tempValue)) continue;
                this.modifyParam.add(objValue);
            }
            long id = modifyData.getLongValue(MysqlCondition.this.masterTable.getPK().getDb_name().toLowerCase());
            if (id <= 0L) {
                id = modifyData.getLongValue(MysqlCondition.this.masterTable.getPK().getDb_name().toUpperCase());
            }
            StringBuffer updateSql = new StringBuffer("update ");
            updateSql.append(MysqlCondition.this.masterTable.getRealFunctionName()).append(" set ");
            updateSql.append(modifySql).append(" where ");
            updateSql.append(MysqlCondition.this.masterTable.getPK().getDb_name()).append("=?");
            this.modifyParam.add(id);
            return updateSql.toString();
        }
    }

    private class CreateUtil {
        private List<Object> insertParam = new ArrayList<Object>();

        private CreateUtil() {
        }

        private String getSql(JSONObject dataParam, List<Column> userColumns) {
            if (dataParam == null || dataParam.isEmpty()) {
                log.error("create param is null");
                throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\u9700\u8981\u521b\u5efa\u7684\u6570\u636e");
            }
            JSONObject createData = dataParam.getJSONObject("master_object");
            if (createData == null || createData.isEmpty()) {
                log.error("master_object is null param:" + dataParam);
                throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\u9700\u8981\u521b\u5efa\u7684\u6570\u636e");
            }
            if (userColumns == null || userColumns.size() <= 0) {
                log.error("create columns is null param:" + dataParam);
                throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\u9700\u8981\u521b\u5efa\u7684\u5b57\u6bb5");
            }
            StringBuffer createSql = new StringBuffer();
            StringBuffer valueSql = new StringBuffer();
            Object objValue = null;
            String tempValue = null;
            int clength = userColumns.size();
            Column tempColumn = null;
            for (int i = 0; i < clength; ++i) {
                tempValue = "?";
                tempColumn = userColumns.get(i);
                if (tempColumn == null) {
                    log.error("create user columns is null");
                    throw new CommonException("-50", "\u8981\u521b\u5efa\u6570\u636e\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!createData.containsKey((Object)tempColumn.getDb_name().toLowerCase()) && !createData.containsKey((Object)tempColumn.getDb_name().toUpperCase()) && StringUtils.isNull((Object)tempColumn.getDefaultValue()) && tempColumn.isNullable() || tempColumn.getVoluationType() == EVoluationType.pk || tempColumn.getVoluationType() == EVoluationType.ignore) continue;
                objValue = createData.get((Object)tempColumn.getDb_name().toLowerCase());
                if (StringUtils.isNull((Object)objValue)) {
                    objValue = createData.get((Object)tempColumn.getDb_name().toUpperCase());
                }
                if (tempColumn.getVoluationType() == EVoluationType.createdatetime || tempColumn.getVoluationType() == EVoluationType.operatedatetime) {
                    tempValue = "now()";
                    objValue = tempValue;
                } else if (tempColumn.getVoluationType() == EVoluationType.creater || tempColumn.getVoluationType() == EVoluationType.operater) {
                    objValue = dataParam.getString("user_id");
                } else if (StringUtils.isNull((Object)objValue)) {
                    objValue = tempColumn.getDefaultValue();
                }
                if (!tempColumn.isNullable() && StringUtils.isNull((Object)objValue)) {
                    log.error("column:" + MysqlCondition.this.masterTable.getDBName() + "." + tempColumn.getDb_name() + " set is not null but value is null");
                    throw new CommonException("-80", "\u8bf7\u7ef4\u62a4\uff1a" + tempColumn.getShow_name());
                }
                if (createSql.length() > 0) {
                    createSql.append(",");
                }
                if (valueSql.length() > 0) {
                    valueSql.append(",");
                }
                if (StringUtils.isNull((Object)objValue)) {
                    tempValue = null;
                }
                createSql.append(tempColumn.getDb_name());
                if ("?".equals(tempValue)) {
                    this.insertParam.add(objValue);
                }
                valueSql.append(tempValue);
            }
            StringBuffer insertSql = new StringBuffer("insert into ");
            insertSql.append(MysqlCondition.this.masterTable.getRealFunctionName()).append("(");
            insertSql.append(createSql).append(") values(");
            insertSql.append(valueSql).append(")");
            return insertSql.toString();
        }
    }

    private class QueryUtil {
        private LogicExpression le;
        private List<Column> columns;
        private List<Object> dataParam = new ArrayList<Object>();
        private StringBuffer columnSb = new StringBuffer();
        private StringBuffer foreignTableSb = new StringBuffer();
        private StringBuffer conditionSb = new StringBuffer();
        private StringBuffer orderBySb = new StringBuffer();
        private int dataBegin;
        private int dataNum;
        private List<String> foreignColuns = new ArrayList<String>();
        private List<Function> foreignTables = new ArrayList<Function>();

        private QueryUtil() {
        }

        private StringBuffer setCondition(LogicExpression le) {
            StringBuffer sqlsb = new StringBuffer();
            if (le == null || le.getAllExpression() == null) {
                return null;
            }
            int lecount = le.getAllExpression().size();
            LogicExpression temple = null;
            if (lecount > 0) {
                sqlsb.append("(");
                for (int i = 0; i < lecount; ++i) {
                    temple = le.getAllExpression().get(i);
                    if (sqlsb.length() > 1) {
                        sqlsb.append(" ").append(temple.getEl().getCode()).append(" ");
                    }
                    sqlsb.append(this.setCondition(temple));
                }
                sqlsb.append(")");
            } else {
                if (sqlsb.length() > 1) {
                    sqlsb.append(" ").append(le.getEl().getCode()).append(" ");
                }
                sqlsb.append(this.setSubCondidtion(le));
            }
            return sqlsb;
        }

        private StringBuffer setSubCondidtion(LogicExpression le) {
            String decorateStr = "";
            String tableTag = MysqlCondition.this.masterTable.getDBName();
            String columnTag = le.getColumnDBName();
            String tempColumnValue = le.getValue();
            StringBuffer subsql = new StringBuffer();
            if (StringUtils.isNull((Object)tempColumnValue)) {
                return subsql;
            }
            tempColumnValue = tempColumnValue.trim();
            Pattern pp = Pattern.compile("(?<=^\\s*[\\[\\{])[^\\)\\}]+(?=\\s*[\\]\\}]\\s*$)");
            Matcher mm = null;
            pp = Pattern.compile("(?<=\\W+)\\w+\\s*[\\[||}]$");
            mm = pp.matcher(columnTag);
            if (mm.find()) {
                decorateStr = columnTag;
                columnTag = mm.group();
                decorateStr = decorateStr.replace(columnTag, "");
            }
            this.disposeForeignColumn(columnTag, tableTag, columnTag);
            if (le.getERelation() == ERelation.range) {
                pp = Pattern.compile("(?<=^\\s*[\\[\\{])[^\\]\\}]+(?=[\\]\\}]\\s*$)");
                mm = pp.matcher(tempColumnValue);
                if (mm.find()) {
                    String tempValue = mm.group();
                    String[] values = tempValue.split("\\s+TO\\s+");
                    if (values == null || values.length < 2) {
                        return subsql;
                    }
                    if ("*".equals(values[0].trim()) && "*".equals(values[1].trim())) {
                        if (StringUtils.isNotNull((Object)tableTag)) {
                            subsql.append(tableTag).append(".");
                        }
                        subsql.append(columnTag).append(" is not null");
                        return subsql;
                    }
                    if ("*".equals(values[0].trim()) && !"*".equals(values[1].trim())) {
                        pp = Pattern.compile("[\\]]\\s*$");
                        mm = pp.matcher(tempColumnValue);
                        if (StringUtils.isNotNull((Object)tableTag)) {
                            subsql.append(tableTag).append(".");
                        }
                        subsql.append(columnTag).append(" <");
                        if (mm.find()) {
                            subsql.append("= ");
                        }
                        subsql.append("?");
                        this.dataParam.add(values[1]);
                        return subsql;
                    }
                    if (!"*".equals(values[0].trim()) && "*".equals(values[1].trim())) {
                        pp = Pattern.compile("^\\s*[\\[]");
                        mm = pp.matcher(tempColumnValue);
                        if (StringUtils.isNotNull((Object)tableTag)) {
                            subsql.append(tableTag).append(".");
                        }
                        subsql.append(columnTag).append(" >");
                        if (mm.find()) {
                            subsql.append("= ");
                        }
                        subsql.append("?");
                        this.dataParam.add(values[0]);
                        return subsql;
                    }
                    if (!"*".equals(values[0].trim()) && !"*".equals(values[1].trim())) {
                        pp = Pattern.compile("^\\s*[\\[]");
                        mm = pp.matcher(tempColumnValue);
                        subsql.append(" (");
                        if (StringUtils.isNotNull((Object)tableTag)) {
                            subsql.append(tableTag).append(".");
                        }
                        subsql.append(columnTag).append(" >");
                        if (mm.find()) {
                            subsql.append("= ");
                        }
                        subsql.append("?");
                        this.dataParam.add(values[0]);
                        pp = Pattern.compile("[\\]]\\s*$");
                        mm = pp.matcher(tempColumnValue);
                        subsql.append(" and ");
                        if (StringUtils.isNotNull((Object)tableTag)) {
                            subsql.append(tableTag).append(".");
                        }
                        subsql.append(columnTag).append(" <");
                        if (mm.find()) {
                            subsql.append("= ");
                        }
                        subsql.append("?");
                        this.dataParam.add(values[1]);
                        subsql.append(" )");
                        return subsql;
                    }
                }
                pp = Pattern.compile("\\s+AND\\s+");
                mm = pp.matcher(tempColumnValue);
                String[] values = null;
                String tempValue = null;
                int vlength = 0;
                String logicStr = "OR";
                if (mm.find()) {
                    logicStr = "AND";
                }
                if ((vlength = (values = tempColumnValue.split("(\\s+(AND|OR)\\s+)")).length) > 1) {
                    subsql.append("(");
                }
                for (int i = 0; i < vlength; ++i) {
                    tempValue = values[i];
                    if (StringUtils.isNull((Object)tempValue)) continue;
                    if (i > 0) {
                        subsql.append(" ").append(logicStr).append(" ");
                    }
                    if ((mm = (pp = Pattern.compile("^\\s*\\*|\\*\\s*$")).matcher(tempValue)).find()) {
                        tempValue = tempValue.replaceAll("^\\s*\\*|\\*\\s*$", "%");
                        if (StringUtils.isNotNull((Object)tableTag)) {
                            subsql.append(tableTag).append(".");
                        }
                        subsql.append(columnTag);
                        if (StringUtils.isNotNull((Object)decorateStr) && "NOT".equalsIgnoreCase(decorateStr)) {
                            subsql.append(" not");
                        }
                        subsql.append(" like ?");
                        this.dataParam.add(tempValue);
                        continue;
                    }
                    if (StringUtils.isNotNull((Object)tableTag)) {
                        subsql.append(tableTag).append(".");
                    }
                    subsql.append(columnTag);
                    if (StringUtils.isNotNull((Object)decorateStr) && "NOT".equalsIgnoreCase(decorateStr)) {
                        subsql.append(" <> ?");
                    } else {
                        subsql.append(" = ?");
                    }
                    this.dataParam.add(tempValue);
                }
                if (vlength > 1) {
                    subsql.append(")");
                }
            } else {
                if (StringUtils.isNotNull((Object)tableTag)) {
                    subsql.append(tableTag).append(".");
                }
                subsql.append(tableTag).append(le.getERelation().getCode()).append(tempColumnValue);
            }
            return subsql;
        }

        private void setSearchColumns(List<Column> columns) {
            this.columnSb = new StringBuffer();
            if (columns == null || columns.size() <= 0) {
                return;
            }
            this.columnSb.append(MysqlCondition.this.masterTable.getDBName()).append(".").append(MysqlCondition.this.masterTable.getPK().getDb_name());
            int clength = columns.size();
            Column c = null;
            String columnTag = null;
            String tableTag = null;
            for (int i = 0; i < clength; ++i) {
                c = columns.get(i);
                if (c == null || c.getId() == MysqlCondition.this.masterTable.getPK().getId() || c.getVoluationType() == EVoluationType.ignore) continue;
                tableTag = MysqlCondition.this.masterTable.getDBName();
                columnTag = c.getDb_name();
                this.disposeForeignColumn(c, tableTag, columnTag);
                this.columnSb.append(",");
                if (StringUtils.isNotNull((Object)tableTag)) {
                    this.columnSb.append(tableTag).append(".");
                }
                this.columnSb.append(columnTag);
            }
        }

        private void setLe(LogicExpression le) {
            this.le = le;
            this.conditionSb = this.setCondition(le);
        }

        private JSONObject disposeForeignColumn(String columnDBName, String tableTag, String columnTag) {
            Column tempColumn = MysqlCondition.this.masterTable.getColumnByDBName(columnDBName);
            if (tempColumn == null) {
                log.error("column:" + columnTag + " not in table:" + MysqlCondition.this.masterTable.getDBName());
                throw new CommonException("-50", "\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            log.debug("-----disposeForeignColumn:" + columnDBName + "," + tableTag + "," + columnTag);
            return this.disposeForeignColumn(tempColumn, tableTag, columnTag);
        }

        private JSONObject disposeForeignColumn(Column c, String tableTag, String columnTag) {
            Column tempColumn = c;
            Function tempTable = MysqlCondition.this.masterTable;
            tableTag = MysqlCondition.this.masterTable.getDBName();
            columnTag = c.getDb_name();
            log.debug("-------disposeForeignColumn:" + tableTag + "," + columnTag);
            if (c.getDb_name().indexOf(";") > -1) {
                String virtualName = null;
                String[] columnsarray = c.getDb_name().split(".|;");
                int index = -1;
                int clength = columnsarray.length;
                for (int i = 0; i < clength - 1; ++i) {
                    columnTag = columnsarray[i];
                    tempColumn = tempTable.getColumnByDBName(columnTag.trim());
                    if (tempColumn == null) {
                        log.error("foreign column:" + columnTag + " is not in table:" + tempTable.getDBName());
                        throw new CommonException("-50", "\u5b57\u6bb5\uff1a" + columnTag + " \u7ef4\u62a4\u6709\u8bef");
                    }
                    tempTable = tempColumn.getForeign_table();
                    if (tempTable == null) {
                        log.error("column:" + columnTag + " foreign table is null");
                        throw new CommonException("-70", "\u5b57\u6bb5\uff1a" + tempColumn.getShow_name() + "\u672a\u7ef4\u62a4\u5916\u952e\u5173\u8054\u8868");
                    }
                    index = this.foreignColuns.indexOf(virtualName = StringUtils.isNull(virtualName) ? tempColumn.getDb_name() : virtualName + "." + tempColumn.getDb_name());
                    if (index > -1) {
                        tableTag = "t" + index;
                        continue;
                    }
                    tableTag = "t" + this.foreignColuns.size();
                    this.foreignColuns.add(virtualName);
                    if (tempTable.getPK() == null) {
                        log.error("table:" + tempTable.getDBName() + " not pk column");
                        throw new CommonException("-70", "\u8868\uff1a" + tempTable.getShowName() + " \u672a\u7ef4\u62a4\u4e3b\u952e");
                    }
                    this.foreignTableSb.append(" left join ").append(tempTable.getRealFunctionName()).append(" ").append(tableTag);
                    this.foreignTableSb.append(" on ").append(MysqlCondition.this.masterTable.getDBName()).append(".").append(tempColumn.getDb_name()).append("=").append(tableTag).append(".").append(tempTable.getPK().getDb_name());
                }
                columnTag = columnsarray[clength - 1];
                tempColumn = tempTable.getColumnByDBName(columnTag.trim());
                if (tempColumn == null) {
                    log.error("foreign column:" + columnTag + " is not in table:" + tempTable.getDBName());
                    throw new CommonException("-50", "\u5b57\u6bb5\uff1a" + columnTag + " \u7ef4\u62a4\u6709\u8bef");
                }
                if (tempColumn != null && tempColumn.getVoluationType() == EVoluationType.ignore) {
                    columnTag = columnTag.replaceAll("(?<=\\()" + tempTable.getDBName() + "(?=\\.)", tableTag);
                    tableTag = "";
                }
            }
            JSONObject result = new JSONObject();
            result.put("tableTag", (Object)tableTag);
            result.put("columnTag", (Object)columnTag);
            return result;
        }

        private void setOrderBy(JSONArray orderby) {
            this.orderBySb = new StringBuffer();
            if (orderby == null || orderby.size() <= 0) {
                return;
            }
            this.orderBySb.append(" order by ");
            int oblength = orderby.size();
            String columnDBName = "";
            boolean isAsc = false;
            JSONObject orderByInfo = null;
            String tableTag = null;
            String columnTag = null;
            for (int i = 0; i < oblength; ++i) {
                orderByInfo = orderby.getJSONObject(i);
                columnDBName = orderByInfo.getString("column");
                JSONObject foreignColumn = this.disposeForeignColumn(columnDBName, tableTag, columnTag);
                if (foreignColumn.containsKey((Object)"tableTag")) {
                    tableTag = foreignColumn.getString("tableTag");
                }
                if (foreignColumn.containsKey((Object)"columnTag")) {
                    columnTag = foreignColumn.getString("columnTag");
                }
                log.debug("----setOrderBy:" + tableTag + "," + columnTag);
                isAsc = "Y".equalsIgnoreCase(orderByInfo.getString("is_asc"));
                if (i > 0) {
                    this.orderBySb.append(",");
                }
                if (StringUtils.isNotNull((Object)tableTag)) {
                    this.orderBySb.append(tableTag).append(".");
                }
                this.orderBySb.append(columnTag);
                if (isAsc) {
                    this.orderBySb.append(" asc");
                    continue;
                }
                this.orderBySb.append(" desc");
            }
            log.debug("------order by :" + this.orderBySb.toString());
        }

        private void setPage(int beginIndex, int endIndex) {
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            this.dataBegin = beginIndex;
            if (endIndex <= 0) {
                endIndex = 10;
            }
            this.dataNum = endIndex;
        }

        private String getCountSql() {
            StringBuffer countSql = new StringBuffer("select count(1) from ").append(MysqlCondition.this.masterTable.getRealFunctionName());
            countSql.append(" ").append(MysqlCondition.this.masterTable.getDBName());
            if (this.conditionSb != null && this.conditionSb.length() > 0) {
                countSql.append(" where ").append(this.conditionSb);
            }
            return countSql.toString();
        }

        private String getQuerySql() {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select ").append(this.columnSb);
            querySql.append(" from ").append(MysqlCondition.this.masterTable.getRealFunctionName()).append(" ").append(MysqlCondition.this.masterTable.getDBName());
            if (this.foreignTableSb != null && this.foreignTableSb.length() > 0) {
                querySql.append(" ").append(this.foreignTableSb);
            }
            if (this.conditionSb != null && this.conditionSb.length() > 0) {
                querySql.append(" where ").append(this.conditionSb);
            }
            if (this.orderBySb != null && this.orderBySb.length() > 0) {
                querySql.append(" ").append(this.orderBySb);
            }
            if (this.dataBegin > 0 || this.dataNum > 0) {
                querySql.append(" limit ").append(this.dataBegin).append(",").append(this.dataNum);
            }
            return querySql.toString();
        }
    }
}

