/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest.condition;

import java.util.HashMap;
import java.util.Map;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;

public enum ERelation {
    greaterthan(">", "\u5927\u4e8e"),
    greaterthanequalto(">=", "\u5927\u4e8e\u7b49\u4e8e"),
    lessthan("<", "\u5c0f\u4e8e"),
    lessthanequalto(">=", "\u5c0f\u4e8e\u7b49\u4e8e"),
    equal("=", "\u7b49\u4e8e"),
    notequal("!=", "\u4e0d\u7b49\u4e8e"),
    like("LIKE", ""),
    notlike("NOT LIKE", ""),
    exists("EXISTS", ""),
    notexists("NOT EXISTS", ""),
    regexp("REGEXP", ""),
    notregexp("NOT REGEXP", ""),
    in("IN", "\u5305\u542b"),
    notin("NOT IN", "\u4e0d\u5305\u542b"),
    range(":", "");

    private static Map<String, ERelation> allrelation;
    private String code;
    private String desc;

    private ERelation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ERelation getERelation(String code) {
        ERelation er = null;
        if (StringUtils.isNull((Object)code)) {
            throw new CommonException("-40", "\u5173\u7cfb\u8fd0\u7b97\u7b26\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tempCode = code.replaceAll("^\\s+|\\s+$", "");
        tempCode = code.replaceAll("\\s+", " ");
        if (!allrelation.containsKey(tempCode)) {
            throw new CommonException("-40", "\u5173\u7cfb\u8fd0\u7b97\u7b26\u9519\u8bef");
        }
        er = allrelation.get(tempCode.toLowerCase());
        return er;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        allrelation = new HashMap<String, ERelation>();
        allrelation.put(">", greaterthan);
        allrelation.put(">=", greaterthanequalto);
        allrelation.put("<", lessthan);
        allrelation.put("<=", lessthanequalto);
        allrelation.put("=", equal);
        allrelation.put("!=", notequal);
        allrelation.put(":", range);
    }
}

