/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.rest;

import kr.weitao.common.util.spring.SpringUtils;
import kr.weitao.starter.util.jdbc.JdbcAutoConfiguration;
import kr.weitao.starter.util.jdbc.JdbcDataEngine;
import kr.weitao.starter.util.rest.dataengine.MySQLDataEngine;
import kr.weitao.starter.util.rest.dataengine.RedisDataEngine;
import kr.weitao.starter.util.rest.query.GetSysConfigure;
import kr.weitao.starter.util.rest.query.ObjectCreate;
import kr.weitao.starter.util.rest.query.ObjectDelete;
import kr.weitao.starter.util.rest.query.ObjectModify;
import kr.weitao.starter.util.rest.query.Query;
import kr.weitao.starter.util.rest.schema.FunctionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackageClasses={FunctionManager.class, RedisDataEngine.class, MySQLDataEngine.class, GetSysConfigure.class, JdbcDataEngine.class})
@ConditionalOnClass(value={Query.class, FunctionManager.class, RedisDataEngine.class, MySQLDataEngine.class, GetSysConfigure.class, JdbcDataEngine.class})
@AutoConfigureAfter(value={JdbcAutoConfiguration.class})
public class RestAutoConfiguration {
    @Autowired
    ConfigurableApplicationContext configurableApplicationContext;
    @Autowired
    private FunctionManager tableManager;

    @Bean(name={"query"})
    @ConditionalOnMissingBean(value={Query.class})
    public Query getQuery() {
        Query query = new Query();
        SpringUtils.setApplicationContext((ConfigurableApplicationContext)this.configurableApplicationContext);
        query.setFunctionManager(this.tableManager);
        return query;
    }

    @Bean(name={"create"})
    @ConditionalOnMissingBean(value={ObjectCreate.class})
    public ObjectCreate create() {
        SpringUtils.setApplicationContext((ConfigurableApplicationContext)this.configurableApplicationContext);
        ObjectCreate objectCreate = new ObjectCreate();
        return objectCreate;
    }

    @Bean(name={"update"})
    @ConditionalOnMissingBean(value={ObjectModify.class})
    public ObjectModify update() {
        SpringUtils.setApplicationContext((ConfigurableApplicationContext)this.configurableApplicationContext);
        ObjectModify om = new ObjectModify();
        return om;
    }

    @Bean(name={"delete"})
    @ConditionalOnMissingBean(value={ObjectDelete.class})
    public ObjectDelete delete() {
        SpringUtils.setApplicationContext((ConfigurableApplicationContext)this.configurableApplicationContext);
        ObjectDelete od = new ObjectDelete();
        return od;
    }
}

