/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.redis;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class ZSetOps {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean addItem(String key, Object item, double score, Long secs) {
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.add((Object)key, item, score);
        this.redisTemplate.expire((Object)key, secs.longValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean removeItem(String key, Object ... item) {
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.remove((Object)key, item);
        return true;
    }

    public Long getSize(String key) {
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        return zSetOperations.size((Object)key);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZSetOps)) {
            return false;
        }
        ZSetOps other = (ZSetOps)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        return !(this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZSetOps;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "ZSetOps(redisTemplate=" + this.getRedisTemplate() + ")";
    }
}

