/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.redis;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class ValueOps {
    private static final Logger log = LoggerFactory.getLogger(ValueOps.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public boolean setValueStringWithExpire(String key, String value, Long secs) {
        ValueOperations valueOperations = this.stringRedisTemplate.opsForValue();
        valueOperations.set((Object)key, (Object)value);
        this.stringRedisTemplate.expire((Object)key, secs.longValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean setValueStringWithExpire(String key, String value, Long secs, TimeUnit tu) {
        ValueOperations valueOperations = this.stringRedisTemplate.opsForValue();
        valueOperations.set((Object)key, (Object)value);
        this.stringRedisTemplate.expire((Object)key, secs.longValue(), tu);
        return true;
    }

    public boolean setValueStringExpireAt(String key, String value, Date expireData) {
        ValueOperations valueOperations = this.stringRedisTemplate.opsForValue();
        valueOperations.set((Object)key, (Object)value);
        this.stringRedisTemplate.expireAt((Object)key, expireData);
        return true;
    }

    public boolean setValueString(String key, String value) {
        ValueOperations stringValueOperations = this.stringRedisTemplate.opsForValue();
        stringValueOperations.set((Object)key, (Object)value);
        return true;
    }

    public String getValueString(String key) {
        ValueOperations valueOperations = this.stringRedisTemplate.opsForValue();
        return (String)valueOperations.get((Object)key);
    }

    public boolean setValueObjectWithExpire(String key, Object object, Long secs) {
        ValueOperations objectValueOperations = this.redisTemplate.opsForValue();
        objectValueOperations.set((Object)key, object);
        this.redisTemplate.expire((Object)key, secs.longValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean setValueObjectExpireAt(String key, Object object, Date expireData) {
        ValueOperations objectValueOperations = this.redisTemplate.opsForValue();
        objectValueOperations.set((Object)key, object);
        this.redisTemplate.expireAt((Object)key, expireData);
        return true;
    }

    public Object getValueObject(String key) {
        ValueOperations objectValueOperations = this.redisTemplate.opsForValue();
        return objectValueOperations.get((Object)key);
    }

    public Set query_keys(String key) {
        Set result = null;
        try {
            result = this.redisTemplate.keys((Object)key);
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return result;
    }

    public void remove(String key) {
        ValueOperations objectValueOperations = this.redisTemplate.opsForValue();
        objectValueOperations.getOperations().delete((Object)key);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueOps)) {
            return false;
        }
        ValueOps other = (ValueOps)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        StringRedisTemplate this$stringRedisTemplate = this.getStringRedisTemplate();
        StringRedisTemplate other$stringRedisTemplate = other.getStringRedisTemplate();
        return !(this$stringRedisTemplate == null ? other$stringRedisTemplate != null : !this$stringRedisTemplate.equals(other$stringRedisTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueOps;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        StringRedisTemplate $stringRedisTemplate = this.getStringRedisTemplate();
        result = result * 59 + ($stringRedisTemplate == null ? 43 : $stringRedisTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "ValueOps(redisTemplate=" + this.getRedisTemplate() + ", stringRedisTemplate=" + this.getStringRedisTemplate() + ")";
    }
}

