/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.redis;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.stereotype.Component;

@Component
public class SetOps {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean addItem(String key, Object item, Long secs) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        setOperations.add((Object)key, new Object[]{item});
        this.redisTemplate.expire((Object)key, secs.longValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean removeItem(String key, Object ... item) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        setOperations.remove((Object)key, item);
        return true;
    }

    public boolean getItem(String key, Object ... item) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        setOperations.remove((Object)key, item);
        return true;
    }

    public Long getSize(String key) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        return setOperations.size((Object)key);
    }

    public Set<Object> union(String key, String otherKey) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        return setOperations.union((Object)key, (Object)otherKey);
    }

    public Set<Object> union(String key, Collection<String> collection) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        return setOperations.union((Object)key, collection);
    }

    public Set<Object> getAll(String key) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        return setOperations.members((Object)key);
    }

    public Set query_keys(String key) {
        Set result = null;
        try {
            result = this.redisTemplate.keys((Object)key);
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return result;
    }

    public void remove(String key) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        setOperations.remove((Object)key, new Object[0]);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetOps)) {
            return false;
        }
        SetOps other = (SetOps)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        return !(this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetOps;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "SetOps(redisTemplate=" + this.getRedisTemplate() + ")";
    }
}

