/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.redis;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kr.weitao.starter.util.redis.ListOps;
import kr.weitao.starter.util.redis.SetOps;
import kr.weitao.starter.util.redis.ValueOps;
import kr.weitao.starter.util.redis.ZSetOps;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisClient {
    private static final Logger log = LoggerFactory.getLogger(RedisClient.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ValueOps valueOps;
    @Autowired
    private SetOps setOps;
    @Autowired
    private ListOps listOps;
    @Autowired
    private ZSetOps zSetOps;

    public void setDataBase(int index) {
        RedisConnectionFactory rcf = this.redisTemplate.getConnectionFactory();
        if (rcf instanceof JedisConnectionFactory) {
            JedisConnectionFactory jcf = (JedisConnectionFactory)rcf;
            jcf.setDatabase(index);
        }
    }

    public boolean delete(String key) {
        this.redisTemplate.delete((Object)key);
        return true;
    }

    public boolean setExpire(String key, Long secs) {
        this.redisTemplate.expire((Object)key, secs.longValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean setExpireAt(String key, Date expireData) {
        this.redisTemplate.expireAt((Object)key, expireData);
        return true;
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Set query_keys(String key) {
        Set result = null;
        try {
            log.info("\u5224\u65ad\u662f\u5426\u5b58\u5728---" + key);
            result = this.redisTemplate.keys((Object)key);
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return result;
    }

    public List<Map<String, Object>> query_result(String key) {
        ArrayList<Map<String, Object>> redis_result = new ArrayList<Map<String, Object>>();
        try {
            Set result = this.query_keys(key);
            if (result != null && result.size() > 0) {
                for (String str : result) {
                    HashedMap map = new HashedMap();
                    Object result_temp = this.getValueOps().getValueObject(str);
                    map.put(str, result_temp);
                    redis_result.add((Map<String, Object>)map);
                }
            }
        }
        catch (Exception var8) {
            var8.printStackTrace();
        }
        return redis_result;
    }

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public ValueOps getValueOps() {
        return this.valueOps;
    }

    public SetOps getSetOps() {
        return this.setOps;
    }

    public ListOps getListOps() {
        return this.listOps;
    }

    public ZSetOps getZSetOps() {
        return this.zSetOps;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setValueOps(ValueOps valueOps) {
        this.valueOps = valueOps;
    }

    public void setSetOps(SetOps setOps) {
        this.setOps = setOps;
    }

    public void setListOps(ListOps listOps) {
        this.listOps = listOps;
    }

    public void setZSetOps(ZSetOps zSetOps) {
        this.zSetOps = zSetOps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisClient)) {
            return false;
        }
        RedisClient other = (RedisClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        if (this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate)) {
            return false;
        }
        ValueOps this$valueOps = this.getValueOps();
        ValueOps other$valueOps = other.getValueOps();
        if (this$valueOps == null ? other$valueOps != null : !((Object)this$valueOps).equals(other$valueOps)) {
            return false;
        }
        SetOps this$setOps = this.getSetOps();
        SetOps other$setOps = other.getSetOps();
        if (this$setOps == null ? other$setOps != null : !((Object)this$setOps).equals(other$setOps)) {
            return false;
        }
        ListOps this$listOps = this.getListOps();
        ListOps other$listOps = other.getListOps();
        if (this$listOps == null ? other$listOps != null : !((Object)this$listOps).equals(other$listOps)) {
            return false;
        }
        ZSetOps this$zSetOps = this.getZSetOps();
        ZSetOps other$zSetOps = other.getZSetOps();
        return !(this$zSetOps == null ? other$zSetOps != null : !((Object)this$zSetOps).equals(other$zSetOps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        ValueOps $valueOps = this.getValueOps();
        result = result * 59 + ($valueOps == null ? 43 : ((Object)$valueOps).hashCode());
        SetOps $setOps = this.getSetOps();
        result = result * 59 + ($setOps == null ? 43 : ((Object)$setOps).hashCode());
        ListOps $listOps = this.getListOps();
        result = result * 59 + ($listOps == null ? 43 : ((Object)$listOps).hashCode());
        ZSetOps $zSetOps = this.getZSetOps();
        result = result * 59 + ($zSetOps == null ? 43 : ((Object)$zSetOps).hashCode());
        return result;
    }

    public String toString() {
        return "RedisClient(redisTemplate=" + this.getRedisTemplate() + ", valueOps=" + this.getValueOps() + ", setOps=" + this.getSetOps() + ", listOps=" + this.getListOps() + ", zSetOps=" + this.getZSetOps() + ")";
    }
}

