/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.redis;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ListOps {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean setItemValueByIndex(String key, long index, Object value) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        listOperations.set((Object)key, index, value);
        return true;
    }

    public boolean trim(String key, long start, int end) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        listOperations.trim((Object)key, start, (long)end);
        return true;
    }

    public boolean removeItem(String key, long count, Object value) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        listOperations.remove((Object)key, count, value);
        return true;
    }

    public List getAllItem(String key) {
        return this.getItemByRange(key, 0L, -1L);
    }

    public List getItemByRange(String key, long start, long end) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        return listOperations.range((Object)key, 0L, -1L);
    }

    public Object getItemByIndex(String key, long index) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        return listOperations.index((Object)key, index);
    }

    public Long push(String key, String value) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        return listOperations.leftPush((Object)key, (Object)value);
    }

    public Object pop(String key) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        return listOperations.leftPop((Object)key);
    }

    public Long in(String key, String value) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        return listOperations.rightPush((Object)key, (Object)value);
    }

    public Object out(String key) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        return listOperations.leftPop((Object)key);
    }

    public Long getSize(String key) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        return listOperations.size((Object)key);
    }

    public <T> ListOperations<String, T> setCacheList(String key, List<T> dataList) {
        ListOperations listOperation = this.redisTemplate.opsForList();
        if (null != dataList) {
            int size = dataList.size();
            for (int i = 0; i < size; ++i) {
                listOperation.leftPush((Object)key, dataList.get(i));
            }
        }
        return listOperation;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOps)) {
            return false;
        }
        ListOps other = (ListOps)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisTemplate<String, Object> this$redisTemplate = this.getRedisTemplate();
        RedisTemplate<String, Object> other$redisTemplate = other.getRedisTemplate();
        return !(this$redisTemplate == null ? other$redisTemplate != null : !this$redisTemplate.equals(other$redisTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListOps;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisTemplate<String, Object> $redisTemplate = this.getRedisTemplate();
        result = result * 59 + ($redisTemplate == null ? 43 : $redisTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "ListOps(redisTemplate=" + this.getRedisTemplate() + ")";
    }
}

