/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.oss.OssProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssClient {
    private static final Logger log = LoggerFactory.getLogger(OssClient.class);
    private OssProperties ossProperties;
    private OSSClient ossClient;

    public void setOssProperties(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }

    public void init() {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMaxConnections(2000);
        conf.setSocketTimeout(10000);
        conf.setMaxErrorRetry(5);
        log.debug("---->oss init:" + this.ossProperties.getBucket() + "," + this.ossProperties.getAccessId() + "," + this.ossProperties.getAccessKey());
        this.ossClient = new OSSClient(this.ossProperties.getEndpoint(), this.ossProperties.getAccessId(), this.ossProperties.getAccessKey(), conf);
        boolean exists = this.ossClient.doesBucketExist(this.ossProperties.getBucket());
        if (!exists) {
            this.ossClient.createBucket(this.ossProperties.getBucket());
            this.ossClient.setBucketAcl(this.ossProperties.getBucket(), CannedAccessControlList.PublicReadWrite);
        }
    }

    public boolean passURL(String urlstr, String dirpath, String yourKey) {
        ObjectMetadata meta = new ObjectMetadata();
        meta.setCacheControl("no-cache");
        meta.setContentType("image/jpeg");
        meta.setContentDisposition("inline;filename=" + yourKey);
        try {
            InputStream inputStream = new URL(urlstr).openStream();
            if (this.ossClient == null) {
                this.init();
            }
            this.ossClient.putObject(this.ossProperties.getBucket(), dirpath + yourKey, inputStream, meta);
            if (inputStream != null) {
                inputStream.close();
            }
            return true;
        }
        catch (Exception e) {
            this.destory();
            log.error("Error Message: " + e.getMessage());
            return false;
        }
    }

    public boolean passFileStrem(String yourKey, String dirpath, InputStream fis) {
        if (this.ossClient == null) {
            this.init();
        }
        boolean bool = true;
        try {
            this.ossClient.putObject(this.ossProperties.getBucket(), dirpath + yourKey, fis);
        }
        catch (Exception e) {
            bool = false;
            this.destory();
        }
        return bool;
    }

    public boolean passFileStrem(String yourKey, String dirpath, String filename) {
        if (this.ossClient == null) {
            this.init();
        }
        boolean bool = true;
        try {
            FileInputStream inputStream = new FileInputStream(filename);
            this.ossClient.putObject(this.ossProperties.getBucket(), dirpath + yourKey, (InputStream)inputStream);
        }
        catch (IOException e) {
            bool = false;
            this.destory();
        }
        return bool;
    }

    public String ossDownObject(String yourKey) throws IOException {
        if (this.ossClient == null) {
            this.init();
        }
        ObjectListing objectListing = this.ossClient.listObjects(this.ossProperties.bucket);
        for (OSSObjectSummary objectSummary : objectListing.getObjectSummaries()) {
            log.info(" - " + objectSummary.getKey() + "  (size = " + objectSummary.getSize() + ")");
        }
        boolean exists = this.ossClient.doesBucketExist(this.ossProperties.bucket);
        if (!exists) {
            return "Bucket\u4e0d\u5b58\u5728";
        }
        OSSObject ossObject = this.ossClient.getObject(this.ossProperties.bucket, yourKey);
        InputStream content = ossObject.getObjectContent();
        StringBuffer sb = new StringBuffer();
        if (content != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(content));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                log.info("\n" + line);
            }
            content.close();
        }
        this.destory();
        return sb.toString();
    }

    public void ossDownLocal(String yourKey, String yourLocalFile) {
        if (this.ossClient == null) {
            this.init();
        }
        this.ossClient.getObject(new GetObjectRequest(this.ossProperties.bucket, yourKey), new File(yourLocalFile));
        this.destory();
    }

    public void destory() {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
    }

    protected String getUrl(String youKey) {
        if (this.ossClient == null) {
            this.init();
        }
        Date expiration = new Date(System.currentTimeMillis() + 315360000000L);
        URL url = this.ossClient.generatePresignedUrl(this.ossProperties.getBucket(), youKey, expiration);
        if (url != null) {
            return url.getProtocol() + "://" + url.getAuthority() + url.getPath();
        }
        return null;
    }

    public String getImgUrl(String fileUrl, String dir) {
        if (StringUtils.isNotNull((Object)fileUrl)) {
            String[] split = fileUrl.split("/");
            return this.getUrl(dir + split[split.length - 1]);
        }
        return null;
    }

    public String getFileUrl(String dirpath, String fileUrl) {
        return this.getUrl(dirpath + fileUrl);
    }

    public void deleteFile(String diskName, String key) {
        if (this.ossClient == null) {
            this.init();
        }
        this.ossClient.deleteObject(this.ossProperties.bucket, diskName + key);
        log.debug("---->oss \u5220\u9664\u6210\u529f" + diskName + "," + key);
    }

    public boolean existObject(String dirpath, String yourKey) {
        if (this.ossClient == null) {
            this.init();
        }
        return this.ossClient.doesObjectExist(this.ossProperties.getBucket(), dirpath + yourKey);
    }

    public OSSClient getOssClient() {
        if (this.ossClient == null) {
            this.init();
        }
        return this.ossClient;
    }

    public static void main(String[] args) {
        OssClient client = new OssClient();
        client.getOssClient();
    }
}

