/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.ons;

import com.aliyun.openservices.ons.api.Admin;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kr.weitao.starter.util.ons.MessageBaseProducer;
import kr.weitao.starter.util.ons.MessageProducerService;
import kr.weitao.starter.util.ons.MqProperties;
import kr.weitao.starter.util.ons.annotation.MessageProducer;
import kr.weitao.starter.util.ons.constants.ProducerType;
import kr.weitao.starter.util.ons.util.MessageApplicationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.CollectionUtils;

public class MqProducerRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MqProducerRunner.class);
    private List<Producer> producerList = new ArrayList<Producer>();
    private List<OrderProducer> orderProducerList = new ArrayList<OrderProducer>();
    @Autowired
    private AbstractApplicationContext applicationContext;
    @Autowired
    private MqProperties mqProperties;
    @Value(value="${spring.profiles.active}")
    String active;

    public void destroy() throws Exception {
        if (!CollectionUtils.isEmpty(this.producerList)) {
            this.producerList.forEach(Producer::shutdown);
        }
        if (!CollectionUtils.isEmpty(this.orderProducerList)) {
            this.orderProducerList.forEach(Admin::shutdown);
        }
    }

    public void run(String ... strings) throws Exception {
        MessageApplicationUtils.getBeanNamesByTypeWithAnnotation(MessageProducerService.class, MessageProducer.class, this.applicationContext).forEach(name -> {
            Producer producer;
            MessageBaseProducer messageProducerService = (MessageBaseProducer)this.applicationContext.getBeanFactory().getBean(name, MessageBaseProducer.class);
            MessageProducer messageProducerAnn = (MessageProducer)this.applicationContext.findAnnotationOnBean(name, MessageProducer.class);
            String groupId = messageProducerAnn.groupId();
            String topic = messageProducerAnn.topic();
            String tag = messageProducerAnn.tag();
            if ("dev".equals(this.active)) {
                topic = "dev_" + topic;
            }
            log.debug("topic:" + topic);
            messageProducerService.setTopIc(topic);
            messageProducerService.setTag(tag);
            ProducerType providerType = messageProducerAnn.producerType();
            Properties properties = new Properties();
            properties.setProperty("AccessKey", this.mqProperties.getConfig().get("AccessKey").toString());
            log.debug("accessKey:" + this.mqProperties.getConfig().get("AccessKey").toString());
            properties.setProperty("SecretKey", this.mqProperties.getConfig().get("SecretKey").toString());
            if (this.mqProperties.getConfig().get("NAMESRV_ADDR") != null) {
                properties.setProperty("NAMESRV_ADDR", this.mqProperties.getConfig().get("NAMESRV_ADDR").toString());
            }
            properties.setProperty("GROUP_ID", groupId);
            if (providerType == ProducerType.DELAY) {
                producer = ONSFactory.createProducer((Properties)properties);
                messageProducerService.setProducer(producer);
                producer.start();
                this.producerList.add(producer);
            }
            if (providerType == ProducerType.NORMAL) {
                producer = ONSFactory.createProducer((Properties)properties);
                messageProducerService.setProducer(producer);
                producer.start();
                this.producerList.add(producer);
            }
            if (providerType == ProducerType.TIMER) {
                producer = ONSFactory.createProducer((Properties)properties);
                messageProducerService.setProducer(producer);
                producer.start();
                this.producerList.add(producer);
            }
            if (providerType == ProducerType.ORDER) {
                producer = ONSFactory.createOrderProducer((Properties)properties);
                messageProducerService.setOrderProducer((OrderProducer)producer);
                producer.start();
                this.orderProducerList.add((OrderProducer)producer);
            }
            log.info("'{}' message producer has been registered.", (Object)messageProducerService.getClass().getName());
            if (providerType == ProducerType.TRANSACTION) {
                throw new RuntimeException("\u4e8b\u52a1\u6d88\u606f\u6682\u65f6\u4e0d\u652f\u6301");
            }
        });
    }
}

