/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.ons;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Admin;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.order.OrderAction;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kr.weitao.starter.util.ons.MessageConsumerService;
import kr.weitao.starter.util.ons.MqProperties;
import kr.weitao.starter.util.ons.annotation.MessageConsumer;
import kr.weitao.starter.util.ons.constants.ConsumerType;
import kr.weitao.starter.util.ons.util.MessageApplicationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.SerializationUtils;

public class MqConsumerRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MqConsumerRunner.class);
    private List<Consumer> consumerList;
    private List<OrderConsumer> orderConsumerList;
    @Autowired
    private AbstractApplicationContext applicationContext;
    @Autowired
    private MqProperties mqProperties;
    @Value(value="${spring.profiles.active}")
    String active;

    public void destroy() throws Exception {
        log.info("Shutting down MessageConsumer server ...");
        if (!CollectionUtils.isEmpty(this.consumerList)) {
            this.consumerList.forEach(Admin::shutdown);
        }
        if (!CollectionUtils.isEmpty(this.orderConsumerList)) {
            this.orderConsumerList.forEach(OrderConsumer::shutdown);
        }
        log.info("MessageConsumer server stopped.");
    }

    public void run(String ... strings) throws Exception {
        HashMap consumerServiceMap = new HashMap();
        MessageApplicationUtils.getBeanNamesByTypeWithAnnotation(MessageConsumerService.class, MessageConsumer.class, this.applicationContext).forEach(name -> {
            MessageConsumerService messageConsumerService = (MessageConsumerService)this.applicationContext.getBeanFactory().getBean(name, MessageConsumerService.class);
            MessageConsumer messageConsumerAnn = (MessageConsumer)this.applicationContext.findAnnotationOnBean(name, MessageConsumer.class);
            String topIc = messageConsumerAnn.topic();
            String tag = messageConsumerAnn.tag();
            String groupId = messageConsumerAnn.groupId();
            ConsumerType consumerType = messageConsumerAnn.consumerType();
            if ("dev".equals(this.active)) {
                topIc = "dev_" + topIc;
            }
            consumerServiceMap.put(topIc, this.createConsumerServiceWarp(messageConsumerService, topIc, tag, groupId, consumerType));
            log.info("'{}' message consumer has been registered.", (Object)messageConsumerService.getClass().getName());
        });
        if (!CollectionUtils.isEmpty(consumerServiceMap)) {
            this.consumerList = new ArrayList<Consumer>();
            this.orderConsumerList = new ArrayList<OrderConsumer>();
            for (Map.Entry entry : consumerServiceMap.entrySet()) {
                Consumer consumer;
                Properties properties = new Properties();
                properties.setProperty("AccessKey", this.mqProperties.getConfig().get("AccessKey").toString());
                properties.setProperty("SecretKey", this.mqProperties.getConfig().get("SecretKey").toString());
                if (this.mqProperties.getConfig().get("NAMESRV_ADDR") != null) {
                    properties.setProperty("NAMESRV_ADDR", this.mqProperties.getConfig().get("NAMESRV_ADDR").toString());
                }
                properties.setProperty("GROUP_ID", ((ConsumerServiceWarp)entry.getValue()).groupId);
                if (((ConsumerServiceWarp)entry.getValue()).consumerType == ConsumerType.DELAY || ((ConsumerServiceWarp)entry.getValue()).consumerType == ConsumerType.NORMAL || ((ConsumerServiceWarp)entry.getValue()).consumerType == ConsumerType.TIMER) {
                    consumer = ONSFactory.createConsumer((Properties)properties);
                    consumer.subscribe((String)entry.getKey(), ((ConsumerServiceWarp)entry.getValue()).tag, (message, context) -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Received: " + message);
                        }
                        return (Action)((ConsumerServiceWarp)entry.getValue()).messageConsumerService.receiveMessage(SerializationUtils.deserialize((byte[])message.getBody()));
                    });
                    consumer.start();
                    this.consumerList.add(consumer);
                }
                if (((ConsumerServiceWarp)entry.getValue()).consumerType == ConsumerType.ORDER) {
                    consumer = ONSFactory.createOrderedConsumer((Properties)properties);
                    consumer.subscribe((String)entry.getKey(), ((ConsumerServiceWarp)entry.getValue()).tag, (message, context) -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Received: " + message);
                        }
                        return (OrderAction)((ConsumerServiceWarp)entry.getValue()).messageConsumerService.receiveMessage(SerializationUtils.deserialize((byte[])message.getBody()));
                    });
                    consumer.start();
                    this.orderConsumerList.add((OrderConsumer)consumer);
                }
                if (((ConsumerServiceWarp)entry.getValue()).consumerType != ConsumerType.TRANSACTION) continue;
                throw new RuntimeException("\u4e8b\u52a1\u6d88\u606f\u6682\u65f6\u4e0d\u652f\u6301");
            }
        }
    }

    private ConsumerServiceWarp createConsumerServiceWarp(MessageConsumerService MessageConsumerService2, String topic, String tag, String groupId, ConsumerType consumerType) {
        ConsumerServiceWarp consumerServiceWarp = new ConsumerServiceWarp();
        consumerServiceWarp.setMessageConsumerService(MessageConsumerService2);
        consumerServiceWarp.setTag(tag);
        consumerServiceWarp.setTopic(topic);
        consumerServiceWarp.setGroupId(groupId);
        consumerServiceWarp.setConsumerType(consumerType);
        return consumerServiceWarp;
    }

    protected class ConsumerServiceWarp {
        private MessageConsumerService messageConsumerService;
        private String topic;
        private String tag;
        private String groupId;
        private ConsumerType consumerType;

        protected ConsumerServiceWarp() {
        }

        public MessageConsumerService getMessageConsumerService() {
            return this.messageConsumerService;
        }

        public void setMessageConsumerService(MessageConsumerService messageConsumerService) {
            this.messageConsumerService = messageConsumerService;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public ConsumerType getConsumerType() {
            return this.consumerType;
        }

        public void setConsumerType(ConsumerType consumerType) {
            this.consumerType = consumerType;
        }
    }
}

