/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.ons;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import kr.weitao.starter.util.ons.constants.MessageType;
import kr.weitao.starter.util.ons.message.MessageBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class MessageBaseProducer {
    private static final Logger log = LoggerFactory.getLogger(MessageBaseProducer.class);
    private Producer producer;
    private OrderProducer orderProducer;
    private String tag;
    private String topIc;
    @Value(value="${spring.profiles.active}")
    String active;

    public SendResult sendMessage(MessageBase message) {
        log.debug(" sendMessage  topic:" + this.getTopIc());
        String key = message.getKey();
        if (message.getMessageType() == MessageType.TIMER || message.getMessageType() == MessageType.DELAY) {
            Message timerMessage = new Message(this.getTopIc(), this.getTag(), message.getSerializeMessage());
            timerMessage.setStartDeliverTime(message.getStartDeliverTime().longValue());
            timerMessage.setKey(key);
            return this.sendMessage(timerMessage);
        }
        Message normalMessage = new Message(this.getTopIc(), this.getTag(), message.getSerializeMessage());
        normalMessage.setKey(key);
        return this.sendMessage(normalMessage);
    }

    public SendResult sendMessage(MessageBase message, String shardingKey) {
        String key = message.getKey();
        if (message.getMessageType() == MessageType.TIMER || message.getMessageType() == MessageType.DELAY) {
            Message timerMessage = new Message(this.getTopIc(), this.getTag(), message.getSerializeMessage());
            timerMessage.setStartDeliverTime(message.getStartDeliverTime().longValue());
            timerMessage.setKey(key);
            return this.sendOrderMessage(timerMessage, shardingKey);
        }
        Message normalMessage = new Message(this.getTopIc(), this.getTag(), message.getSerializeMessage());
        normalMessage.setKey(key);
        return this.sendOrderMessage(normalMessage, shardingKey);
    }

    private SendResult sendMessage(Message message) {
        if (this.producer == null) {
            throw new RuntimeException("\u6d88\u606f\u7c7b\u578b\u4e0e\u751f\u4ea7\u8005\u7c7b\u578b\u4e0d\u4e00\u81f4");
        }
        return this.producer.send(message);
    }

    private SendResult sendOrderMessage(Message message, String shardingKey) {
        if (this.orderProducer == null) {
            throw new RuntimeException("\u6d88\u606f\u7c7b\u578b\u4e0e\u751f\u4ea7\u8005\u7c7b\u578b\u4e0d\u4e00\u81f4");
        }
        return this.orderProducer.send(message, shardingKey);
    }

    public Producer getProducer() {
        return this.producer;
    }

    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTopIc() {
        return this.topIc;
    }

    public void setTopIc(String topIc) {
        this.topIc = topIc;
    }

    public OrderProducer getOrderProducer() {
        return this.orderProducer;
    }

    public void setOrderProducer(OrderProducer orderProducer) {
        this.orderProducer = orderProducer;
    }
}

