/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.mongodb;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Multimap;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.DateSwitchUtil;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import kr.weitao.starter.util.mongodb.BathUpdateOptions;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbUtil {
    private static final Logger log = LoggerFactory.getLogger(MongodbUtil.class);

    public static BasicDBObject changeCondition(JSONObject jsonObject, JSONObject show_type) {
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBList basicDBList = new BasicDBList();
        Set iterator = jsonObject.entrySet();
        for (Map.Entry map : iterator) {
            String key = (String)map.getKey();
            String value = map.getValue().toString();
            Pattern pattern = Pattern.compile("^" + value + ".*$", 2);
            if (!key.equals("open_id")) {
                if ("date_range".equals(show_type.getString(key))) {
                    String send_time_value = value;
                    String[] strings = send_time_value.split("~");
                    String start_time = "*";
                    String end_time = "*";
                    if (strings.length == 1) {
                        start_time = send_time_value.split("~")[0].trim();
                        end_time = "*";
                    } else {
                        start_time = send_time_value.split("~")[0].trim();
                        end_time = send_time_value.split("~")[1].trim();
                        if (org.apache.commons.lang.StringUtils.isBlank((String)start_time)) {
                            start_time = "*";
                        }
                        if (org.apache.commons.lang.StringUtils.isBlank((String)end_time)) {
                            end_time = "*";
                        }
                    }
                    if (!"*".equals(start_time)) {
                        BasicDBObject basicDBObject1 = new BasicDBObject();
                        basicDBObject1.put((Object)"$gte", (Object)start_time);
                        basicDBList.add((Object)new BasicDBObject(key, (Object)basicDBObject1));
                    }
                    if ("*".equals(end_time)) continue;
                    BasicDBObject basicDBObject2 = new BasicDBObject();
                    basicDBObject2.put((Object)"$lte", (Object)end_time);
                    basicDBList.add((Object)new BasicDBObject(key, (Object)basicDBObject2));
                    continue;
                }
                BasicDBObject basicDBObject1 = new BasicDBObject();
                basicDBObject1.put((Object)"$regex", (Object)value);
                basicDBObject1.put((Object)"$options", (Object)"i");
                basicDBList.add((Object)new BasicDBObject(key, (Object)basicDBObject1));
                continue;
            }
            BasicDBList values = new BasicDBList();
            log.info("changeCondition-value-open_id-" + value);
            for (int j = 0; j < value.split(",").length; ++j) {
                values.add((Object)value.split(",")[j]);
            }
            BasicDBObject basicDBObject_ = new BasicDBObject();
            basicDBObject_.put((Object)"$in", (Object)values);
            basicDBList.add((Object)new BasicDBObject("open_id", (Object)basicDBObject_));
        }
        basicDBObject.put((Object)"$and", (Object)basicDBList);
        return basicDBObject;
    }

    public static BasicDBObject checkMongoUpdate(JSONObject jsonObject) {
        jsonObject.remove((Object)"id");
        jsonObject.remove((Object)"_id");
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject update = new BasicDBObject();
        Set iterator = jsonObject.entrySet();
        for (Map.Entry map : iterator) {
            String key = (String)map.getKey();
            Object value = map.getValue();
            basicDBObject.put((Object)key, value);
        }
        basicDBObject.put((Object)"modified_date", (Object)TimeUtils.getCurrentTimeInString((SimpleDateFormat)TimeUtils.DATETIME_FORMAT_DATE));
        update.put((Object)"$set", (Object)basicDBObject);
        return update;
    }

    public static <T> DBObject bean2DBObject(T bean) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (bean == null) {
            return null;
        }
        BasicDBObject dbObject = new BasicDBObject();
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            Object param;
            String varName = field.getName();
            boolean accessFlag = field.isAccessible();
            if (!accessFlag) {
                field.setAccessible(true);
            }
            if ((param = field.get(bean)) == null) continue;
            if (param instanceof Integer) {
                int value = (Integer)param;
                dbObject.put(varName, (Object)value);
            } else if (param instanceof String) {
                String value = (String)param;
                dbObject.put(varName, (Object)value);
            } else if (param instanceof Double) {
                double value = (Double)param;
                dbObject.put(varName, (Object)value);
            } else if (param instanceof Float) {
                float value = ((Float)param).floatValue();
                dbObject.put(varName, (Object)Float.valueOf(value));
            } else if (param instanceof Long) {
                long value = (Long)param;
                dbObject.put(varName, (Object)value);
            } else if (param instanceof Boolean) {
                boolean value = (Boolean)param;
                dbObject.put(varName, (Object)value);
            } else if (param instanceof Date) {
                Date value = (Date)param;
                dbObject.put(varName, (Object)value);
            }
            field.setAccessible(accessFlag);
        }
        return dbObject;
    }

    public static DBObject Json2DBObject(JSONObject object) throws Exception {
        BasicDBObject dbObject = new BasicDBObject();
        for (String key : object.keySet()) {
            dbObject.put(key, object.get((Object)key));
        }
        return dbObject;
    }

    public static Multimap<String, Map<String, String>> getOldVisitors(String date, DBCollection dbCol) {
        int pagesize = 100000;
        String objectId = "";
        Multimap<String, Map<String, String>> mapless = null;
        BasicDBObject queryless = new BasicDBObject();
        BasicDBObject fields = new BasicDBObject();
        BasicDBObject field = new BasicDBObject();
        field.put((Object)"uuid", (Object)1);
        fields.put((Object)"uuid", (Object)1);
        fields.put((Object)"initTime", (Object)1);
        String conditionless = "";
        queryless.put((Object)"$where", (Object)conditionless);
        DBCursor cursorless = dbCol.find((DBObject)queryless, (DBObject)field);
        int countless = cursorless.count();
        int circleCountless = countless / pagesize;
        int modless = countless % pagesize;
        for (int i = 1; i <= circleCountless + 1; ++i) {
            DBObject obj = null;
            ArrayList<Map> listOfMaps = new ArrayList<Map>();
            if (!"".equals(objectId)) {
                ObjectId id = new ObjectId(objectId);
                queryless.append("_id", (Object)new BasicDBObject("$gt", (Object)id));
            }
            if (i < circleCountless + 1) {
                cursorless = dbCol.find((DBObject)queryless, (DBObject)fields).sort((DBObject)new BasicDBObject("_id", (Object)1)).limit(pagesize);
            } else if (i == circleCountless + 1) {
                cursorless = dbCol.find((DBObject)queryless, (DBObject)fields).limit(modless);
            }
            while (cursorless.hasNext()) {
                obj = cursorless.next();
                listOfMaps.add((Map)obj);
            }
            if (null == obj) continue;
            objectId = obj.get("_id").toString();
        }
        return mapless;
    }

    public static String cron_expression(JSONObject cycle_info) {
        String cron = "";
        if (cycle_info == null || cycle_info.isEmpty()) {
            log.error("cycle_info can not be null");
            throw new CommonException("-1", "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String value = cycle_info.getString("value");
        if (StringUtils.isNull((Object)value)) {
            log.error("cycle can not be null");
            throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] cycle = value.split(",");
        if (cycle == null || cycle.length != 2) {
            log.error("cycle data erroe");
            throw new CommonException("-1", "\u5468\u671f\u6570\u636e\u6709\u8bef");
        }
        LocalDateTime datetime = DateSwitchUtil.parse((String)cycle_info.getString("start_time"));
        StringBuffer cron_sb = new StringBuffer();
        String cycle_type = cycle[0];
        if ("not".equalsIgnoreCase(cycle_type)) {
            cron_sb.append(datetime.getSecond()).append(" ").append(datetime.getMinute()).append(" ").append(datetime.getHour()).append(" ").append(datetime.getDayOfMonth()).append(" ").append(datetime.getMonth().getValue()).append(" ?").append(" ").append(datetime.getYear());
            return cron_sb.toString();
        }
        if ("seconds".equalsIgnoreCase(cycle_type)) {
            cron_sb.append("*/").append(cycle[1]);
            cron_sb.append(" * * ? * * ");
            return cron_sb.toString();
        }
        if ("minutes".equalsIgnoreCase(cycle_type)) {
            cron_sb.append("0 */").append(cycle[1]);
            cron_sb.append(" * ? * * ");
            return cron_sb.toString();
        }
        if ("hours".equalsIgnoreCase(cycle_type)) {
            cron_sb.append("* * */").append(cycle[1]);
            cron_sb.append(" ? * * ");
            return cron_sb.toString();
        }
        cron_sb.append(datetime.getSecond()).append(" ");
        cron_sb.append(datetime.getMinute()).append(" ");
        cron_sb.append(datetime.getHour());
        if ("day".equalsIgnoreCase(cycle_type)) {
            cron_sb.append(" */").append(cycle[1]);
            cron_sb.append(" * ?");
        } else if ("week".equalsIgnoreCase(cycle[0])) {
            int week = Integer.parseInt(cycle[1]);
            cron_sb.append(" */").append(week * 7);
            cron_sb.append(" * ?");
        } else if ("month".equalsIgnoreCase(cycle[0])) {
            LocalDate last_date = datetime.toLocalDate().with(TemporalAdjusters.lastDayOfMonth());
            LocalDate ld = datetime.toLocalDate();
            if (ld.getDayOfMonth() == ld.lengthOfMonth()) {
                cron_sb.append(" L");
            } else {
                cron_sb.append(" ").append(datetime.getDayOfMonth());
            }
            cron_sb.append(" */").append(cycle[1]);
            cron_sb.append(" ?");
        } else if ("year".equalsIgnoreCase(cycle[0])) {
            LocalDate last_date = datetime.toLocalDate().with(TemporalAdjusters.lastDayOfMonth());
            LocalDate ld = datetime.toLocalDate();
            if (ld.getDayOfMonth() == ld.lengthOfMonth()) {
                cron_sb.append(" L");
            } else {
                cron_sb.append(" ").append(datetime.getDayOfMonth());
            }
            cron_sb.append(" ").append(datetime.getMonth());
            cron_sb.append(" ?");
            cron_sb.append(" */").append(cycle[1]);
        }
        return cron_sb.toString();
    }

    public static LocalDateTime getEndTime(JSONObject cycle_info) {
        LocalDateTime ldt = null;
        if (cycle_info == null || cycle_info.isEmpty()) {
            log.error("cycle can not be null");
            return ldt;
        }
        int count = cycle_info.getIntValue("cycle");
        if (count <= 0) {
            log.info("count is 0");
            return ldt;
        }
        String cycle = cycle_info.getString("value");
        if (StringUtils.isNull((Object)cycle)) {
            log.error("cycle value can not be null");
            return ldt;
        }
        String[] cycle_array = cycle.split(",");
        if (cycle == null || cycle_array.length != 2) {
            log.error("cycle data erroe");
            return ldt;
        }
        String cycle_type = cycle_array[0];
        if (!StringUtils.isDigital((String)cycle_array[1])) {
            log.error("cycle value mast is Digital");
        }
        int cycle_value = -1;
        try {
            cycle_value = Integer.parseInt(cycle_array[1]);
        }
        catch (Exception e) {
            log.error("parse cycle value to integer error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u5fc5\u987b\u662f\u6574\u6570\u503c");
        }
        LocalDateTime start_time = DateSwitchUtil.parse((String)cycle_info.getString("start_time"));
        if ("not".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusSeconds(1L);
            return ldt;
        }
        if (cycle_value <= 0) {
            log.error("cycle value mast more then 0");
            ldt = start_time.plusSeconds(1L);
            return ldt;
        }
        cycle_value *= count;
        if ("seconds".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusSeconds(cycle_value);
        } else if ("minutes".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusMinutes(cycle_value);
        } else if ("hours".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusHours(1L);
        } else if ("day".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusDays(cycle_value);
        } else if ("week".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusWeeks(cycle_value);
        } else if ("month".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusMonths(cycle_value);
        } else if ("year".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusYears(cycle_value);
        }
        return ldt;
    }

    public static LocalDateTime getStartTime(JSONObject cycle_info) {
        LocalDateTime ldt = null;
        if (cycle_info == null || cycle_info.isEmpty()) {
            log.error("cycle can not be null");
            return ldt;
        }
        int count = cycle_info.getIntValue("cycle");
        if (count <= 0) {
            log.info("count is 0");
            return ldt;
        }
        String cycle = cycle_info.getString("value");
        if (StringUtils.isNull((Object)cycle)) {
            log.error("cycle value can not be null");
            return ldt;
        }
        String[] cycle_array = cycle.split(",");
        if (cycle == null || cycle_array.length != 2) {
            log.error("cycle data erroe");
            return ldt;
        }
        String cycle_type = cycle_array[0];
        if (!StringUtils.isDigital((String)cycle_array[1])) {
            log.error("cycle value mast is Digital");
        }
        int cycle_value = -1;
        try {
            cycle_value = Integer.parseInt(cycle_array[1]);
        }
        catch (Exception e) {
            log.error("parse cycle value to integer error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("-1", "\u63d0\u9192\u5468\u671f\u5fc5\u987b\u662f\u6574\u6570\u503c");
        }
        LocalDateTime start_time = cycle_info.containsKey((Object)"remind_time") ? DateSwitchUtil.parse((String)cycle_info.getString("remind_time")) : DateSwitchUtil.parse((String)cycle_info.getString("order_time"));
        if ("not".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusSeconds(1L);
            return ldt;
        }
        if (cycle_value <= 0) {
            ldt = start_time.plusSeconds(1L);
            return ldt;
        }
        cycle_value *= count;
        if ("seconds".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusSeconds(cycle_value);
        } else if ("minutes".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusMinutes(cycle_value);
        } else if ("hours".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusHours(cycle_value);
        } else if ("day".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusDays(cycle_value);
        } else if ("week".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusWeeks(cycle_value);
        } else if ("month".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusMonths(cycle_value);
        } else if ("year".equalsIgnoreCase(cycle_type)) {
            ldt = start_time.plusYears(cycle_value);
        }
        return ldt;
    }

    public static String El2Str1(String el) {
        String str = "";
        str = el.replace("$", "");
        str = str.replace("*", "\\*");
        str = str.replace("(", "\\(");
        str = str.replace(")", "\\)");
        str = str.replace("[", "\\[");
        str = str.replace("]", "\\]");
        str = str.replace("+", "\\+");
        str = str.replace("?", "\\?");
        return str;
    }

    public static int doBathUpdate(DBCollection dbCollection, String collName, List<BathUpdateOptions> options, boolean ordered) {
        BasicDBObject command = new BasicDBObject();
        command.put("update", (Object)collName);
        ArrayList<BasicDBObject> updateList = new ArrayList<BasicDBObject>();
        for (BathUpdateOptions option : options) {
            BasicDBObject update = new BasicDBObject();
            update.put((Object)"q", (Object)option.getQuery().getQueryObject());
            update.put((Object)"u", (Object)option.getUpdate().getUpdateObject());
            update.put((Object)"upsert", (Object)option.isUpsert());
            update.put((Object)"multi", (Object)option.isMulti());
            updateList.add(update);
        }
        command.put("updates", updateList);
        command.put("ordered", (Object)ordered);
        CommandResult commandResult = dbCollection.getDB().command((DBObject)command);
        return Integer.parseInt(commandResult.get("n").toString());
    }

    public static ArrayList iteratorToArray(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }
}

