/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.mongodb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.util.mongodb.MongodbProperties;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

public class MongodbClient {
    private static final Logger log = LoggerFactory.getLogger(MongodbClient.class);
    private static MongoClient mongoClient = null;
    private static MongoTemplate mongoTemplate = null;
    private static MongoDbFactory mongoDbFactory = null;
    private MongodbProperties mongodbProperties;

    public static DBCursor sortAndPage(DBCursor dbCursor, int page_num, int page_size, String sort_key, int sort_type) {
        if (page_num >= 0 && page_size > 0) {
            dbCursor = dbCursor.skip((page_num - 1) * page_size).limit(page_size);
        }
        if (!sort_key.equals("") && null != sort_key) {
            BasicDBObject sort_obj = new BasicDBObject(sort_key, (Object)sort_type);
            dbCursor = dbCursor.sort((DBObject)sort_obj);
        }
        return dbCursor;
    }

    public static BasicDBObject rangeQuery(String date_field, String start_time, String end_time) {
        BasicDBObject rangeQuery = new BasicDBObject();
        HashedMap map = new HashedMap();
        map.put("$gte", start_time);
        map.put("$lte", end_time);
        rangeQuery.put((Object)date_field, (Object)map);
        return rangeQuery;
    }

    public MongoClient getMongoClient() throws UnknownHostException {
        if (mongoClient == null) {
            ArrayList<ServerAddress> seedList = new ArrayList<ServerAddress>();
            log.debug("mongodb host name: " + this.mongodbProperties.getHost());
            String[] hosts = this.mongodbProperties.getHost().split(",");
            for (int credentials = 0; credentials < hosts.length; ++credentials) {
                seedList.add(new ServerAddress(hosts[credentials], this.mongodbProperties.getPort()));
            }
            ArrayList<MongoCredential> var5 = new ArrayList<MongoCredential>();
            var5.add(MongoCredential.createScramSha1Credential((String)this.mongodbProperties.getUsername(), (String)this.mongodbProperties.getDefaultDataBase(), (char[])this.mongodbProperties.getPassword().toCharArray()));
            MongoClientOptions options = MongoClientOptions.builder().requiredReplicaSetName(this.mongodbProperties.getReplSetName()).socketTimeout(this.mongodbProperties.getSocketTimeOut()).maxWaitTime(this.mongodbProperties.getMaxWaitTime()).threadsAllowedToBlockForConnectionMultiplier(this.mongodbProperties.getThreadsAllowedToBlockForConnectionMultiplier()).connectTimeout(this.mongodbProperties.getConnectTimeout()).heartbeatConnectTimeout(this.mongodbProperties.getHeartbeatConnectTimeout()).socketKeepAlive(this.mongodbProperties.isSocketKeepAlive()).connectionsPerHost(this.mongodbProperties.getMaxConnectionsPerHost()).minConnectionsPerHost(this.mongodbProperties.getMinConnectionsPerHost()).readPreference(ReadPreference.secondaryPreferred()).build();
            mongoClient = new MongoClient(seedList, var5, options);
        }
        return mongoClient;
    }

    public MongoTemplate getMongoTemplate() {
        if (mongoTemplate == null) {
            try {
                if (mongoClient == null) {
                    mongoClient = this.getMongoClient();
                }
                if (mongoDbFactory == null) {
                    mongoDbFactory = new SimpleMongoDbFactory(mongoClient, this.mongodbProperties.getDatabase());
                }
                if (mongoTemplate == null) {
                    MappingMongoConverter e = new MappingMongoConverter(mongoDbFactory, (MappingContext)new MongoMappingContext());
                    e.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper((String)null));
                    mongoTemplate = new MongoTemplate(mongoDbFactory, (MongoConverter)e);
                }
            }
            catch (Exception var2) {
                log.error(var2.getMessage());
            }
        }
        return mongoTemplate;
    }

    private DBCollection getCollection(String collectionName) {
        try {
            return this.getMongoTemplate().getCollection(collectionName);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public boolean insert(String collectionName, Map info) {
        WriteResult wr = this.getCollection(collectionName).insert(new DBObject[]{new BasicDBObject(info)});
        return wr.getN() > 0;
    }

    public boolean delete(String collectionName, Map info) {
        BasicDBObject delObj = new BasicDBObject();
        delObj.putAll(info);
        WriteResult wr = this.getCollection(collectionName).remove((DBObject)delObj);
        return wr.getN() > 0;
    }

    public boolean update(String collectionName, Map newMap, Map oldMap) {
        BasicDBObject newObj = new BasicDBObject();
        BasicDBObject oldObj = new BasicDBObject();
        newObj.putAll(newMap);
        oldObj.putAll(oldMap);
        WriteResult wr = this.getCollection(collectionName).update((DBObject)oldObj, (DBObject)newObj);
        return wr.getN() > 0;
    }

    public List query(String collectionName, Map keyMap) {
        BasicDBObject ref = new BasicDBObject();
        ref.putAll(keyMap);
        DBCursor dbCursor = this.getCollection(collectionName).find((DBObject)ref);
        return this.DBCursorToList(dbCursor);
    }

    public JSONArray query(String collectionName, BasicDBObject keyMap) {
        DBCursor dbCursor = this.getCollection(collectionName).find((DBObject)keyMap);
        return this.disposeDBCursor(dbCursor);
    }

    public JSONArray query(String collectionName, BasicDBObject keyMap, int page_num, int page_size, String sort_key, int sort_type) {
        DBCursor dbCursor = this.getCollection(collectionName).find((DBObject)keyMap);
        dbCursor = MongodbClient.sortAndPage(dbCursor, page_num, page_size, sort_key, sort_type);
        return this.disposeDBCursor(dbCursor);
    }

    private JSONArray disposeDBCursor(DBCursor dbCursor) {
        JSONArray array = new JSONArray();
        while (dbCursor.hasNext()) {
            DBObject obj = dbCursor.next();
            array.add(JSONObject.parseObject((String)obj.toString(), JSONObject.class));
        }
        return array;
    }

    private List DBCursorToList(DBCursor dbCursor) {
        ArrayList<Map> list = new ArrayList<Map>();
        while (dbCursor.hasNext()) {
            DBObject obj = dbCursor.next();
            list.add(obj.toMap());
        }
        return list;
    }

    public JSONObject findOne(String collectionName, BasicDBObject query) {
        return this.findOne(collectionName, query, null);
    }

    public JSONObject findOne(String collectionName, BasicDBObject query, BasicDBObject projection) {
        JSONObject result_data = null;
        if (StringUtils.isNull((Object)collectionName)) {
            log.error("collectionName can not be null");
            throw new CommonException("-1", "\u67e5\u8be2\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (query == null || query.isEmpty()) {
            log.error("query can not be null");
            throw new CommonException("-1", "\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DBObject db_object = null;
        try {
            db_object = projection == null || projection.isEmpty() ? mongoTemplate.getCollection(collectionName).findOne((DBObject)query) : mongoTemplate.getCollection(collectionName).findOne((DBObject)query, (DBObject)projection);
        }
        catch (Exception e) {
            log.error("get data by:" + query + " error:" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (db_object == null) {
            log.info("not find data by:" + query);
            return result_data;
        }
        Object _id = db_object.get("_id");
        Map map = db_object.toMap();
        map.put("id", _id.toString());
        map.remove("_id");
        result_data = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        return result_data;
    }

    public int update(String collectionName, BasicDBObject updateQuery, BasicDBObject updateItem) {
        WriteResult wr = this.updates(collectionName, updateQuery, updateItem);
        if (wr == null) {
            log.info("update by:" + updateQuery + " by update:" + updateItem + " result is null");
            throw new CommonException("-1", "\u66f4\u65b0\u6570\u636e\u5931\u8d25");
        }
        return wr.getN();
    }

    public WriteResult updates(String collectionName, BasicDBObject updateQuery, BasicDBObject updateItem) {
        if (updateQuery == null || updateQuery.isEmpty()) {
            log.error("update query can not be null");
            throw new CommonException("-1", "\u66f4\u65b0\u8bed\u53e5\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (updateItem == null || updateItem.isEmpty()) {
            log.error("update data can not be null");
            throw new CommonException("-1", "\u66f4\u65b0\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BasicDBObject update_data = new BasicDBObject("$set", (Object)updateItem);
        WriteResult wr = null;
        try {
            wr = mongoTemplate.getCollection(collectionName).update((DBObject)updateQuery, (DBObject)update_data);
        }
        catch (Exception e) {
            log.error("update by:" + updateQuery + " by update:" + update_data + " error:" + e.getLocalizedMessage(), (Throwable)e);
            throw new CommonException("-1", "\u66f4\u65b0\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return wr;
    }

    public MongodbProperties getMongodbProperties() {
        return this.mongodbProperties;
    }

    public void setMongodbProperties(MongodbProperties mongodbProperties) {
        this.mongodbProperties = mongodbProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongodbClient)) {
            return false;
        }
        MongodbClient other = (MongodbClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongodbProperties this$mongodbProperties = this.getMongodbProperties();
        MongodbProperties other$mongodbProperties = other.getMongodbProperties();
        return !(this$mongodbProperties == null ? other$mongodbProperties != null : !((Object)this$mongodbProperties).equals(other$mongodbProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongodbClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongodbProperties $mongodbProperties = this.getMongodbProperties();
        result = result * 59 + ($mongodbProperties == null ? 43 : ((Object)$mongodbProperties).hashCode());
        return result;
    }

    public String toString() {
        return "MongodbClient(mongodbProperties=" + this.getMongodbProperties() + ")";
    }
}

