/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.jdbc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Component;

@Component
public class SpringJdbcService {
    private static final Logger log = LogManager.getLogger(SpringJdbcService.class);
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    JdbcTemplate jdbcTemplate;

    public List<Map<String, Object>> get(String sql) {
        List userList = this.jdbcTemplate.queryForList(sql);
        return userList;
    }

    public JSONArray getJSONArray(String sql, Object[] params) {
        JSONArray ja = this.getJSONArray(sql, params, false);
        return ja;
    }

    public int update(String sql, Object[] params) {
        log.debug("update sql:" + sql);
        ArrayList<Object> list = null;
        if (params != null && params.length > 0) {
            list = new ArrayList<Object>();
            Object[] var4 = params;
            int var5 = params.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Object o = var4[var6];
                log.debug("value2:" + o);
                list.add(o == null ? o : StringUtils.valueOf((Object)o));
            }
        }
        return this.jdbcTemplate.update(sql, list != null && list.size() > 0 ? list.toArray() : null);
    }

    public JSONArray getJSONArray(String sql, Object[] params, final boolean toUpper) {
        log.debug("get sql:" + sql);
        if (params != null && params.length > 0) {
            Object[] var4 = params;
            int var5 = params.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                Object o = var4[var6];
                log.debug("value:" + o);
            }
        }
        return (JSONArray)this.jdbcTemplate.query(sql, params, (ResultSetExtractor)new ResultSetExtractor<JSONArray>(){

            public JSONArray extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                ResultSetMetaData rsd = resultSet.getMetaData();
                int clength = rsd.getColumnCount();
                JSONArray ja = new JSONArray();
                try {
                    while (resultSet.next()) {
                        JSONObject jo = new JSONObject();
                        for (int i = 0; i < clength; ++i) {
                            String columnName = rsd.getColumnLabel(i + 1);
                            String string = columnName = toUpper ? columnName.toUpperCase() : columnName.toLowerCase();
                            if (!"createdate".equalsIgnoreCase(columnName) && !"modifydate".equalsIgnoreCase(columnName)) {
                                jo.put(columnName, resultSet.getObject(i + 1));
                                continue;
                            }
                            jo.put(columnName, (Object)TimeUtils.DATETIME_FORMAT_DATE.format(TimeUtils.DATETIME_FORMAT_DATE.parse(resultSet.getObject(i + 1).toString())));
                        }
                        ja.add((Object)jo);
                    }
                }
                catch (Exception var8) {
                    log.debug("get data error:" + var8.getLocalizedMessage());
                    var8.printStackTrace();
                }
                return ja;
            }
        });
    }

    public List<Map<String, Object>> get(String sql, Object[] objects) {
        List userList = this.jdbcTemplate.queryForList(sql, objects);
        return userList;
    }

    public int save(String sql, Object[] objects) {
        int flag = this.jdbcTemplate.update(sql, objects);
        return flag;
    }

    public int delete(String sql) {
        int flag = this.jdbcTemplate.update(sql);
        return flag;
    }

    public int delete(String sql, Object[] objects) {
        int flag = this.jdbcTemplate.update(sql, objects);
        return flag;
    }

    public int update(String sql) {
        int flag = this.jdbcTemplate.update(sql);
        return flag;
    }

    public int getcount(String sql) {
        StringBuffer totalSQL = new StringBuffer(" SELECT count(1) FROM ( ");
        totalSQL.append(sql);
        totalSQL.append(" ) totalTable ");
        int flag = (Integer)this.jdbcTemplate.queryForObject(totalSQL + "", new Object[0], Integer.class);
        return flag;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }
}

