/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.jdbc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import kr.weitao.common.util.StringUtils;
import kr.weitao.common.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcClient {
    private static final Logger log = LoggerFactory.getLogger(JdbcClient.class);
    private JdbcTemplate jdbcTemplate;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setJdbcTemplate(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public long insert(final String sql, final Object[] params) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql, 1);
                if (params == null) {
                    return ps;
                }
                Object op = null;
                int alength = params.length;
                for (int i = 0; i < alength; ++i) {
                    op = params[i];
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, (Object)(op == null ? op : StringUtils.valueOf((Object)op)));
                }
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    public int update(String sql, Object[] params) {
        log.debug("update sql:" + sql);
        ArrayList<Object> list = null;
        if (params != null && params.length > 0) {
            list = new ArrayList<Object>();
            for (Object o : params) {
                log.debug("value2:" + o);
                list.add(o == null ? o : StringUtils.valueOf((Object)o));
            }
        }
        return this.jdbcTemplate.update(sql, list != null && list.size() > 0 ? list.toArray() : null);
    }

    public int delete(String sql, Object[] params) {
        return this.jdbcTemplate.update(sql, params);
    }

    public JSONObject getJSONObject(String sql, Object[] params) {
        return this.getJSONObject(sql, params, false);
    }

    public JSONObject getJSONObject(String sql, Object[] params, final boolean toUpper) {
        log.debug("save sql:" + sql);
        if (params != null && params.length > 0) {
            for (Object o : params) {
                log.debug("value:" + o);
            }
        }
        return (JSONObject)this.jdbcTemplate.query(sql, params, (ResultSetExtractor)new ResultSetExtractor<JSONObject>(){

            public JSONObject extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                ResultSetMetaData rsd = resultSet.getMetaData();
                int clength = rsd.getColumnCount();
                try {
                    if (resultSet.next()) {
                        JSONObject jo = new JSONObject();
                        for (int i = 0; i < clength; ++i) {
                            String columnName = rsd.getColumnLabel(i + 1);
                            columnName = toUpper ? columnName.toUpperCase() : columnName.toLowerCase();
                            jo.put(columnName, resultSet.getObject(i + 1));
                        }
                        return jo;
                    }
                }
                catch (Exception e) {
                    log.debug("get data error:" + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public JSONArray getJSONArray(String sql, Object[] params) {
        JSONArray ja = this.getJSONArray(sql, params, false);
        return ja;
    }

    public JSONArray getJSONArray(String sql, Object[] params, final boolean toUpper) {
        log.debug("get sql:" + sql);
        if (params != null && params.length > 0) {
            for (Object o : params) {
                log.debug("value:" + o);
            }
        }
        return (JSONArray)this.jdbcTemplate.query(sql, params, (ResultSetExtractor)new ResultSetExtractor<JSONArray>(){

            public JSONArray extractData(ResultSet resultSet) throws SQLException, DataAccessException {
                ResultSetMetaData rsd = resultSet.getMetaData();
                int clength = rsd.getColumnCount();
                JSONArray ja = new JSONArray();
                try {
                    while (resultSet.next()) {
                        JSONObject jo = new JSONObject();
                        for (int i = 0; i < clength; ++i) {
                            String columnName = rsd.getColumnLabel(i + 1);
                            String string = columnName = toUpper ? columnName.toUpperCase() : columnName.toLowerCase();
                            if ("createdate".equalsIgnoreCase(columnName) || "modifydate".equalsIgnoreCase(columnName)) {
                                jo.put(columnName, (Object)TimeUtils.DATETIME_FORMAT_DATE.format(TimeUtils.DATETIME_FORMAT_DATE.parse(resultSet.getObject(i + 1).toString())));
                                continue;
                            }
                            jo.put(columnName, resultSet.getObject(i + 1));
                        }
                        ja.add((Object)jo);
                    }
                }
                catch (Exception e) {
                    log.debug("get data error:" + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                log.debug("---->SpringJdbcService:" + ja.toString());
                return ja;
            }
        });
    }

    public int getCount(String sql, Object[] params) {
        return this.doQueryOne(sql, params, Integer.class);
    }

    public <T> T doQueryOne(String sql, Object[] params, Class<T> returnTtype) {
        log.debug("save sql:" + sql);
        if (params != null && params.length > 0) {
            for (Object o : params) {
                log.debug("value:" + o);
            }
        }
        Object o = null;
        try {
            o = this.jdbcTemplate.queryForObject(sql, params, returnTtype);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)o;
    }
}

