/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.jdbc;

import javax.sql.DataSource;
import kr.weitao.starter.util.jdbc.JdbcClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@ConditionalOnClass(value={JdbcClient.class})
public class JdbcAutoConfiguration {
    @Autowired
    @Qualifier(value="primaryDataSource")
    DataSource primaryDataSource;
    @Autowired
    @Qualifier(value="secondaryDataSource")
    DataSource secondaryDataSource;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    JdbcTemplate jdbcTemplateConfig1;
    @Autowired
    @Qualifier(value="secondaryJdbcTemplate")
    JdbcTemplate jdbcTemplateConfig2;

    @Bean(name={"primaryJdbcClient"})
    public JdbcClient getJdbcClient1() {
        JdbcClient jdbcClient = new JdbcClient();
        jdbcClient.setJdbcTemplate(this.primaryDataSource);
        return jdbcClient;
    }

    @Bean(name={"secondaryJdbcClient"})
    public JdbcClient getJdbcClient2() {
        JdbcClient jdbcClient = new JdbcClient();
        jdbcClient.setJdbcTemplate(this.secondaryDataSource);
        return jdbcClient;
    }
}

