/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.util.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import kr.weitao.starter.util.jdbc.DruidDataSourceProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(value={DruidDataSource.class})
@ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="com.alibaba.druid.pool.DruidDataSource", matchIfMissing=true)
@EnableConfigurationProperties(value={DruidDataSourceProperties.class})
public class DataSourceConfig {
    @Primary
    @Bean(name={"primaryDataSource"})
    @Qualifier(value="primaryDataSource")
    @ConfigurationProperties(prefix="spring.datasource.primary")
    public DruidDataSource primaryDataSource(DruidDataSourceProperties druidDataSourceProperties) {
        DruidDataSource druidDataSource = (DruidDataSource)DataSourceBuilder.create().type(DruidDataSource.class).build();
        druidDataSource.configFromPropety(druidDataSourceProperties.toProperties());
        druidDataSource.setInitialSize(druidDataSourceProperties.getInitialSize().intValue());
        druidDataSource.setMinIdle(druidDataSourceProperties.getMinIdle().intValue());
        druidDataSource.setMaxActive(druidDataSourceProperties.getMaxActive().intValue());
        druidDataSource.setMaxWait(druidDataSourceProperties.getMaxWait().longValue());
        druidDataSource.setConnectProperties(druidDataSourceProperties.getConnectionProperties());
        return druidDataSource;
    }

    @Bean(name={"secondaryDataSource"})
    @Qualifier(value="secondaryDataSource")
    @ConfigurationProperties(prefix="spring.datasource.secondary")
    public DruidDataSource secondaryDataSource(DruidDataSourceProperties druidDataSourceProperties) {
        DruidDataSource druidDataSource = (DruidDataSource)DataSourceBuilder.create().type(DruidDataSource.class).build();
        druidDataSource.configFromPropety(druidDataSourceProperties.toProperties());
        druidDataSource.setInitialSize(druidDataSourceProperties.getInitialSize().intValue());
        druidDataSource.setMinIdle(druidDataSourceProperties.getMinIdle().intValue());
        druidDataSource.setMaxActive(druidDataSourceProperties.getMaxActive().intValue());
        druidDataSource.setMaxWait(druidDataSourceProperties.getMaxWait().longValue());
        druidDataSource.setConnectProperties(druidDataSourceProperties.getConnectionProperties());
        return druidDataSource;
    }

    @Bean
    public FilterRegistrationBean druidWebStatFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid2/*");
        return filterRegistrationBean;
    }

    @Bean
    public ServletRegistrationBean druidStatViewServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        servletRegistrationBean.addInitParameter("allow", "127.0.0.1");
        servletRegistrationBean.addInitParameter("deny", "192.168.1.73");
        servletRegistrationBean.addInitParameter("loginUsername", "root");
        servletRegistrationBean.addInitParameter("loginPassword", "password");
        servletRegistrationBean.addInitParameter("resetEnable", "false");
        return servletRegistrationBean;
    }
}

