/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.mq.aspect;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import kr.weitao.common.util.StringUtils;
import kr.weitao.starter.mq.annotation.ConsumeLogAnnotation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ConsumeLogAspect {
    @Autowired
    MongoTemplate mongoTemplate;

    @Around(value="@annotation(annotation)&& args(param,..)")
    public Object handle(ProceedingJoinPoint pjp, ConsumeLogAnnotation annotation, JSONObject param) throws Throwable {
        this.insertLog(param);
        return pjp.proceed();
    }

    @AfterThrowing(throwing="ex", pointcut="@annotation(annotation)&& args(param,..)")
    public void handle(Throwable ex, ConsumeLogAnnotation annotation, JSONObject param) {
        param.put("error", (Object)ex.getMessage());
        this.insertLog(param);
    }

    private void insertLog(JSONObject param) {
        String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        BasicDBObject log = new BasicDBObject("topic", (Object)param.getString("topic"));
        log.put("tag", (Object)param.getString("tag"));
        log.put("group", param.get((Object)"group"));
        log.put("msg", param.get((Object)"msg"));
        log.put("created_date", (Object)now);
        if (StringUtils.isNull((Object)param.get((Object)"error"))) {
            log.put("status", (Object)"SUCCESS");
        } else {
            log.put("error", param.get((Object)"error"));
            log.put("status", (Object)"FAILURE");
        }
        this.mongoTemplate.getCollection("def_mq_consume_log").insert(new DBObject[]{log});
    }
}

