/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.mq;

import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="rocketmq.producer")
public class MQProducerConfigure {
    private static final Logger log = LoggerFactory.getLogger(MQProducerConfigure.class);
    private String groupName;
    private String namesrvAddr;
    private Integer maxMessageSize;
    private Integer sendMsgTimeOut;
    private Integer retryTimesWhenSendFailed;
    private boolean autoCreateTopicEnable;

    @Bean
    public DefaultMQProducer defaultProducer() throws MQClientException {
        log.info("defaultProducer \u6b63\u5728\u521b\u5efa---------------------------------------");
        DefaultMQProducer producer = new DefaultMQProducer(this.groupName);
        producer.setNamesrvAddr(this.namesrvAddr);
        producer.setMaxMessageSize(this.maxMessageSize.intValue());
        producer.setSendMsgTimeout(this.sendMsgTimeOut.intValue());
        producer.setRetryTimesWhenSendFailed(this.retryTimesWhenSendFailed.intValue());
        producer.start();
        log.info("rocketmq producer server \u5f00\u542f\u6210\u529f----------------------------------");
        return producer;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public Integer getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Integer getSendMsgTimeOut() {
        return this.sendMsgTimeOut;
    }

    public Integer getRetryTimesWhenSendFailed() {
        return this.retryTimesWhenSendFailed;
    }

    public boolean isAutoCreateTopicEnable() {
        return this.autoCreateTopicEnable;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public void setMaxMessageSize(Integer maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setSendMsgTimeOut(Integer sendMsgTimeOut) {
        this.sendMsgTimeOut = sendMsgTimeOut;
    }

    public void setRetryTimesWhenSendFailed(Integer retryTimesWhenSendFailed) {
        this.retryTimesWhenSendFailed = retryTimesWhenSendFailed;
    }

    public void setAutoCreateTopicEnable(boolean autoCreateTopicEnable) {
        this.autoCreateTopicEnable = autoCreateTopicEnable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MQProducerConfigure)) {
            return false;
        }
        MQProducerConfigure other = (MQProducerConfigure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        String this$namesrvAddr = this.getNamesrvAddr();
        String other$namesrvAddr = other.getNamesrvAddr();
        if (this$namesrvAddr == null ? other$namesrvAddr != null : !this$namesrvAddr.equals(other$namesrvAddr)) {
            return false;
        }
        Integer this$maxMessageSize = this.getMaxMessageSize();
        Integer other$maxMessageSize = other.getMaxMessageSize();
        if (this$maxMessageSize == null ? other$maxMessageSize != null : !((Object)this$maxMessageSize).equals(other$maxMessageSize)) {
            return false;
        }
        Integer this$sendMsgTimeOut = this.getSendMsgTimeOut();
        Integer other$sendMsgTimeOut = other.getSendMsgTimeOut();
        if (this$sendMsgTimeOut == null ? other$sendMsgTimeOut != null : !((Object)this$sendMsgTimeOut).equals(other$sendMsgTimeOut)) {
            return false;
        }
        Integer this$retryTimesWhenSendFailed = this.getRetryTimesWhenSendFailed();
        Integer other$retryTimesWhenSendFailed = other.getRetryTimesWhenSendFailed();
        if (this$retryTimesWhenSendFailed == null ? other$retryTimesWhenSendFailed != null : !((Object)this$retryTimesWhenSendFailed).equals(other$retryTimesWhenSendFailed)) {
            return false;
        }
        return this.isAutoCreateTopicEnable() == other.isAutoCreateTopicEnable();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MQProducerConfigure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        String $namesrvAddr = this.getNamesrvAddr();
        result = result * 59 + ($namesrvAddr == null ? 43 : $namesrvAddr.hashCode());
        Integer $maxMessageSize = this.getMaxMessageSize();
        result = result * 59 + ($maxMessageSize == null ? 43 : ((Object)$maxMessageSize).hashCode());
        Integer $sendMsgTimeOut = this.getSendMsgTimeOut();
        result = result * 59 + ($sendMsgTimeOut == null ? 43 : ((Object)$sendMsgTimeOut).hashCode());
        Integer $retryTimesWhenSendFailed = this.getRetryTimesWhenSendFailed();
        result = result * 59 + ($retryTimesWhenSendFailed == null ? 43 : ((Object)$retryTimesWhenSendFailed).hashCode());
        result = result * 59 + (this.isAutoCreateTopicEnable() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "MQProducerConfigure(groupName=" + this.getGroupName() + ", namesrvAddr=" + this.getNamesrvAddr() + ", maxMessageSize=" + this.getMaxMessageSize() + ", sendMsgTimeOut=" + this.getSendMsgTimeOut() + ", retryTimesWhenSendFailed=" + this.getRetryTimesWhenSendFailed() + ", autoCreateTopicEnable=" + this.isAutoCreateTopicEnable() + ")";
    }
}

