/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import kr.weitao.common.exception.CommonException;
import kr.weitao.common.util.MD5Util;

@JSONType
public class DataRequest {
    @JSONField
    @ApiModelProperty(value="\u8bf7\u6c42\u552f\u4e00ID")
    private String id;
    @JSONField
    @ApiModelProperty(value="\u8bf7\u6c42\u65b9\u6cd5")
    private String method;
    @JSONField
    @ApiModelProperty(value="\u8bf7\u6c42\u6765\u6e90")
    private String source;
    @JSONField
    @ApiModelProperty(value="\u8bf7\u6c42\u6570\u636e\u4f53")
    private JSONObject data = new JSONObject();
    @JSONField
    @ApiModelProperty(value="\u767b\u9646\u4eba\u7528\u6237id")
    private String login_user_id;
    @JSONField
    @ApiModelProperty(value="\u767b\u9646\u4eba\u4f01\u4e1a\u7f16\u53f7")
    private String login_corp_code;
    @JSONField
    @ApiModelProperty(value="\u52a0\u5bc6\u5b57\u6bb5")
    private String access_key;
    @JSONField
    @ApiModelProperty(value="\u52a0\u5bc6\u4f53")
    private String sign;
    @JSONField
    @ApiModelProperty(value="\u65f6\u95f4\u6233")
    private String timestamp = String.valueOf(System.currentTimeMillis());

    public DataRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public DataRequest setSource(String source) {
        this.source = source;
        return this;
    }

    public DataRequest setData(JSONObject data) {
        this.data = data;
        return this;
    }

    public DataRequest setAccess_key(String accessKey) {
        this.access_key = accessKey;
        return this;
    }

    public DataRequest setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public DataRequest setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getSign(String accessKey, String secret) {
        String sign = MD5Util.getMD5Str32((String)(accessKey + secret + this.timestamp)).toUpperCase();
        return sign;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public static DataRequest getRequestPayload(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = req.getReader();){
            int len;
            char[] buff = new char[1024];
            while ((len = reader.read(buff)) != -1) {
                sb.append(buff, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("-----\u8bf7\u6c42\u53c2\u6570-----\n" + sb.toString());
        DataRequest dataRequest = (DataRequest)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)sb.toString()), DataRequest.class);
        System.out.println("-----\u8bf7\u6c42\u53c2\u6570-----\n" + dataRequest.toString());
        return dataRequest;
    }

    public static DataRequest getRequestPayload(HttpServletRequest req, String methodName) throws CommonException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = req.getReader();){
            int len;
            char[] buff = new char[1024];
            while ((len = reader.read(buff)) != -1) {
                sb.append(buff, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("-----\u8bf7\u6c42\u53c2\u6570-error----\n" + e.getMessage());
        }
        System.out.println("-----\u8bf7\u6c42\u53c2\u6570-----\n" + sb.toString());
        DataRequest dataRequest = (DataRequest)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)sb.toString()), DataRequest.class);
        String id = dataRequest.getId();
        String method = dataRequest.getMethod();
        String source = dataRequest.getSource();
        if (!"leysenCrm".equals(source)) {
            throw new CommonException("source is error");
        }
        if (!method.equals(methodName)) {
            throw new CommonException("method is error");
        }
        long requestTime = Long.parseLong(id);
        long now = System.currentTimeMillis();
        long diff = now - requestTime;
        long min = diff / 60000L;
        if (min > 10L) {
            throw new CommonException("id is error");
        }
        String sign = MD5Util.getMD5Str32((String)(id + method + source));
        if (!sign.equals(dataRequest.getSign())) {
            throw new CommonException("sign is error");
        }
        return dataRequest;
    }

    public String getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public String getSource() {
        return this.source;
    }

    public JSONObject getData() {
        return this.data;
    }

    public String getLogin_user_id() {
        return this.login_user_id;
    }

    public String getLogin_corp_code() {
        return this.login_corp_code;
    }

    public String getAccess_key() {
        return this.access_key;
    }

    public String getSign() {
        return this.sign;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogin_user_id(String login_user_id) {
        this.login_user_id = login_user_id;
    }

    public void setLogin_corp_code(String login_corp_code) {
        this.login_corp_code = login_corp_code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRequest)) {
            return false;
        }
        DataRequest other = (DataRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        JSONObject this$data = this.getData();
        JSONObject other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$login_user_id = this.getLogin_user_id();
        String other$login_user_id = other.getLogin_user_id();
        if (this$login_user_id == null ? other$login_user_id != null : !this$login_user_id.equals(other$login_user_id)) {
            return false;
        }
        String this$login_corp_code = this.getLogin_corp_code();
        String other$login_corp_code = other.getLogin_corp_code();
        if (this$login_corp_code == null ? other$login_corp_code != null : !this$login_corp_code.equals(other$login_corp_code)) {
            return false;
        }
        String this$access_key = this.getAccess_key();
        String other$access_key = other.getAccess_key();
        if (this$access_key == null ? other$access_key != null : !this$access_key.equals(other$access_key)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        JSONObject $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $login_user_id = this.getLogin_user_id();
        result = result * 59 + ($login_user_id == null ? 43 : $login_user_id.hashCode());
        String $login_corp_code = this.getLogin_corp_code();
        result = result * 59 + ($login_corp_code == null ? 43 : $login_corp_code.hashCode());
        String $access_key = this.getAccess_key();
        result = result * 59 + ($access_key == null ? 43 : $access_key.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    @ConstructorProperties(value={"id", "method", "source", "data", "login_user_id", "login_corp_code", "access_key", "sign", "timestamp"})
    public DataRequest(String id, String method, String source, JSONObject data, String login_user_id, String login_corp_code, String access_key, String sign, String timestamp) {
        this.id = id;
        this.method = method;
        this.source = source;
        this.data = data;
        this.login_user_id = login_user_id;
        this.login_corp_code = login_corp_code;
        this.access_key = access_key;
        this.sign = sign;
        this.timestamp = timestamp;
    }

    public DataRequest() {
    }
}

