/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.starter.aop;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import kr.weitao.starter.model.DataResponse;
import kr.weitao.starter.model.Status;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

@Aspect
@Component
public class AuthCheckAspect {
    private static final Logger log = LogManager.getLogger(AuthCheckAspect.class);

    @Pointcut(value="execution(* com.whale.cloud.*.controller..*(..)) && @annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void controllerMethodPointcut() {
    }

    @Around(value="controllerMethodPointcut()")
    public Object Interceptor(ProceedingJoinPoint pjp) {
        Object[] args;
        long beginTime = System.currentTimeMillis();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        String methodName = method.getName();
        LinkedHashSet<Map> allParams = new LinkedHashSet<Map>();
        log.info("\u8bf7\u6c42\u5f00\u59cb\uff0c\u65b9\u6cd5\uff1a{}", (Object)methodName);
        Object dataResponse = null;
        for (Object arg : args = pjp.getArgs()) {
            log.debug("arg: {}", arg);
            if (arg instanceof Map) {
                Map map = (Map)arg;
                allParams.add(map);
            }
            if (arg instanceof HttpSession) {
                HttpSession session = (HttpSession)arg;
                if (!this.isLoginRequired(method) || this.isLogin(session)) continue;
                dataResponse = new DataResponse().setStatus(Status.FAILED).setMsg("AccessKey is not exisit");
                log.info("\u5c0f\u6837\u513f\uff0c\u4f60\u6743\u9650\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u8fd9\u6b21\u5c31\u5148\u7ed9\u4f60\u653e\u884c\u4e86");
                continue;
            }
            if (!(arg instanceof HttpServletResponse)) continue;
        }
        try {
            if (dataResponse == null) {
                dataResponse = pjp.proceed();
            }
        }
        catch (Throwable e) {
            log.info("exception: ", e);
            dataResponse = new DataResponse().setStatus(Status.FAILED).setMsg(e.getMessage());
        }
        if (dataResponse instanceof DataResponse) {
            long costMs = System.currentTimeMillis() - beginTime;
            log.info("{} \u8bf7\u6c42\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}ms", (Object)methodName, (Object)costMs);
        }
        return dataResponse;
    }

    private boolean isLoginRequired(Method method) {
        Class<?> clazz = method.getClass();
        if (clazz.isAnnotationPresent(RequestMapping.class)) {
            RequestMapping requestMapping = clazz.getAnnotation(RequestMapping.class);
            String[] path = requestMapping.value();
            log.debug("Mapping path: " + path);
        }
        return true;
    }

    private boolean isLogin(HttpSession session) {
        return false;
    }
}

