/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.Span;
import brave.dubbo.rpc.TracingFilter;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;

final class TracingResponseCallback {
    TracingResponseCallback() {
    }

    static ResponseCallback create(@Nullable ResponseCallback delegate, Span span, CurrentTraceContext current) {
        if (delegate == null) {
            return new FinishSpan(span);
        }
        return new DelegateAndFinishSpan(delegate, span, current);
    }

    static class FinishSpan
    implements ResponseCallback {
        final Span span;

        FinishSpan(Span span) {
            this.span = span;
        }

        public void done(Object response) {
            this.span.finish();
        }

        public void caught(Throwable exception) {
            TracingFilter.onError(exception, this.span);
            this.span.finish();
        }
    }

    static final class DelegateAndFinishSpan
    extends FinishSpan {
        final ResponseCallback delegate;
        final CurrentTraceContext current;

        DelegateAndFinishSpan(ResponseCallback delegate, Span span, CurrentTraceContext current) {
            super(span);
            this.delegate = delegate;
            this.current = current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void done(Object response) {
            try {
                CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
                try {
                    this.delegate.done(response);
                    if (ws == null) return;
                }
                catch (Throwable throwable) {
                    if (ws == null) throw throwable;
                    try {
                        ws.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                ws.close();
                return;
            }
            finally {
                super.done(response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void caught(Throwable exception) {
            try {
                CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
                try {
                    this.delegate.caught(exception);
                    if (ws == null) return;
                }
                catch (Throwable throwable) {
                    if (ws == null) throw throwable;
                    try {
                        ws.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                ws.close();
                return;
            }
            finally {
                super.caught(exception);
            }
        }
    }
}

