/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.dubbo.rpc.DubboClientRequest;
import brave.dubbo.rpc.DubboServerRequest;
import brave.dubbo.rpc.TracingResponseCallback;
import brave.internal.Platform;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.rpc.RpcRequest;
import brave.rpc.RpcTracing;
import brave.sampler.SamplerFunction;
import brave.sampler.SamplerFunctions;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Future;

@Activate(group={"provider", "consumer"}, value={"tracing"})
public final class TracingFilter
implements Filter {
    CurrentTraceContext current;
    Tracer tracer;
    TraceContext.Extractor<DubboServerRequest> extractor;
    TraceContext.Injector<DubboClientRequest> injector;
    SamplerFunction<RpcRequest> clientSampler = SamplerFunctions.deferDecision();
    SamplerFunction<RpcRequest> serverSampler = SamplerFunctions.deferDecision();
    volatile boolean isInit = false;

    public void setTracing(Tracing tracing) {
        this.current = tracing.currentTraceContext();
        this.tracer = tracing.tracer();
        this.extractor = tracing.propagation().extractor(DubboServerRequest.GETTER);
        this.injector = tracing.propagation().injector(DubboClientRequest.SETTER);
        this.isInit = true;
    }

    public void setRpcTracing(RpcTracing rpcTracing) {
        if (rpcTracing == null) {
            throw new NullPointerException("rpcTracing == null");
        }
        this.tracer = rpcTracing.tracing().tracer();
        this.extractor = rpcTracing.tracing().propagation().extractor(DubboServerRequest.GETTER);
        this.injector = rpcTracing.tracing().propagation().injector(DubboClientRequest.SETTER);
        this.clientSampler = rpcTracing.clientSampler();
        this.serverSampler = rpcTracing.serverSampler();
        this.isInit = true;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Span span;
        Span.Kind kind;
        if (!this.isInit) {
            return invoker.invoke(invocation);
        }
        RpcContext rpcContext = RpcContext.getContext();
        Span.Kind kind2 = kind = rpcContext.isProviderSide() ? Span.Kind.SERVER : Span.Kind.CLIENT;
        if (kind.equals((Object)Span.Kind.CLIENT)) {
            Map attachments = RpcContext.getContext().getAttachments();
            DubboClientRequest request = new DubboClientRequest(invocation, attachments);
            span = this.tracer.nextSpan(this.clientSampler, (Object)request);
            this.injector.inject(span.context(), (Object)request);
        } else {
            DubboServerRequest request = new DubboServerRequest(invocation, invocation.getAttachments());
            TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)request);
            span = this.nextSpan(extracted, request);
        }
        if (!span.isNoop()) {
            span.kind(kind);
            String service = invoker.getInterface().getSimpleName();
            String method = RpcUtils.getMethodName((Invocation)invocation);
            span.name(service + "/" + method);
            TracingFilter.parseRemoteAddress(rpcContext, span);
            span.start();
        }
        boolean isOneway = false;
        boolean deferFinish = false;
        CurrentTraceContext.Scope scope = this.current.newScope(span.context());
        Throwable error = null;
        try {
            Result result = invoker.invoke(invocation);
            isOneway = RpcUtils.isOneway((URL)invoker.getUrl(), (Invocation)invocation);
            if (!span.isNoop()) {
                deferFinish = this.ensureSpanFinishes(rpcContext, span, result);
            }
            Result result2 = result;
            return result2;
        }
        catch (Error | RuntimeException e) {
            error = e;
            throw e;
        }
        finally {
            if (error != null) {
                TracingFilter.onError(error, span);
            }
            if (isOneway) {
                span.flush();
            } else if (!deferFinish) {
                span.finish();
            }
            scope.close();
        }
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, DubboServerRequest request) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = this.serverSampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    boolean ensureSpanFinishes(RpcContext rpcContext, Span span, Result result) {
        Future future;
        boolean deferFinish = false;
        if (result.hasException()) {
            TracingFilter.onError(result.getException(), span);
        }
        if ((future = rpcContext.getFuture()) instanceof FutureAdapter) {
            deferFinish = true;
            ResponseFuture original = ((FutureAdapter)future).getFuture();
            FinishSpanResponseFuture wrapped = new FinishSpanResponseFuture(original, span, this.current);
            wrapped.setCallback(null);
            RpcContext.getContext().setFuture((Future)new FutureAdapter((ResponseFuture)wrapped));
        }
        return deferFinish;
    }

    static void parseRemoteAddress(RpcContext rpcContext, Span span) {
        InetSocketAddress remoteAddress = rpcContext.getRemoteAddress();
        if (remoteAddress == null) {
            return;
        }
        span.remoteIpAndPort(Platform.get().getHostString(remoteAddress), remoteAddress.getPort());
    }

    static void onError(Throwable error, Span span) {
        span.error(error);
        if (error instanceof RpcException) {
            span.tag("dubbo.error_code", Integer.toString(((RpcException)error).getCode()));
        }
    }

    static final class FinishSpanResponseFuture
    implements ResponseFuture {
        final ResponseFuture delegate;
        final Span span;
        final CurrentTraceContext current;

        FinishSpanResponseFuture(ResponseFuture delegate, Span span, CurrentTraceContext current) {
            this.delegate = delegate;
            this.span = span;
            this.current = current;
        }

        public Object get() throws RemotingException {
            return this.delegate.get();
        }

        public Object get(int timeoutInMillis) throws RemotingException {
            return this.delegate.get(timeoutInMillis);
        }

        public void setCallback(ResponseCallback callback) {
            this.delegate.setCallback(TracingResponseCallback.create(callback, this.span, this.current));
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }
    }
}

