/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.dubbo.rpc.DubboParser;
import brave.internal.Nullable;
import brave.propagation.Propagation;
import brave.rpc.RpcServerRequest;
import com.alibaba.dubbo.rpc.Invocation;
import java.util.Map;

final class DubboServerRequest
extends RpcServerRequest {
    static final Propagation.Getter<DubboServerRequest, String> GETTER = new Propagation.Getter<DubboServerRequest, String>(){

        public String get(DubboServerRequest request, String key) {
            return request.getAttachment(key);
        }

        public String toString() {
            return "DubboServerRequest::getAttachment";
        }
    };
    final Invocation invocation;
    final Map<String, String> attachments;

    DubboServerRequest(Invocation invocation, Map<String, String> attachments) {
        if (invocation == null) {
            throw new NullPointerException("invocation == null");
        }
        this.invocation = invocation;
        if (attachments == null) {
            throw new NullPointerException("attachments == null");
        }
        this.attachments = attachments;
    }

    public Object unwrap() {
        return this;
    }

    public String method() {
        return DubboParser.method(this.invocation);
    }

    public String service() {
        return DubboParser.service(this.invocation);
    }

    @Nullable
    String getAttachment(String key) {
        return this.attachments.get(key);
    }
}

