/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin;

import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.AttrDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Property;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.PropertyValue;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.enums.PropertyValueTypeEnum;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.query.PropertyQuery;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.PropertyService;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.PropertyFeignProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropertyServiceImpl
implements PropertyService {
    @Autowired
    private PropertyFeignProxy propertyFeignProxy;

    @Override
    public List<AttrDTO> queryAttrDOs(PropertyQuery propertyQuery) {
        ResponseMsg<List<Property>> listResponseMsg = this.propertyFeignProxy.searchProperties(propertyQuery);
        List data = (List)listResponseMsg.getData();
        ArrayList<AttrDTO> attrDTOS = new ArrayList<AttrDTO>();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            data.forEach(property -> {
                AttrDTO attrDTO = new AttrDTO();
                attrDTO.setGmtCreate(property.getGmtCreate());
                attrDTO.setGmtModified(property.getGmtModified());
                attrDTO.setMerchantId(property.getMerchantCode());
                attrDTO.setName(property.getName());
                ResponseMsg<List<PropertyValue>> valuesOfPropertyMsg = this.propertyFeignProxy.getValuesOfProperty(property.getId());
                List propertyValues = (List)valuesOfPropertyMsg.getData();
                if (CollectionUtils.isNotEmpty((Collection)propertyValues)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    propertyValues.forEach(propertyValue -> {
                        if (PropertyValueTypeEnum.DATE_VALUE.getState().equals(propertyValue.getType())) {
                            stringBuilder.append(propertyValue.getDateValue()).append("i");
                        }
                        if (PropertyValueTypeEnum.DOUBLE_VALUE.getState().equals(propertyValue.getType())) {
                            stringBuilder.append(propertyValue.getDoubleValue()).append("i");
                        }
                        if (PropertyValueTypeEnum.STRING_VALUE.getState().equals(propertyValue.getType())) {
                            stringBuilder.append(propertyValue.getStringValue()).append("i");
                        }
                        if (PropertyValueTypeEnum.INT_VALUE.getState().equals(propertyValue.getType())) {
                            stringBuilder.append(propertyValue.getIntValue()).append("i");
                        }
                    });
                    String s = stringBuilder.toString();
                    attrDTO.setValue(s.substring(0, s.length() - 1));
                }
                attrDTO.setId(property.getId());
                attrDTO.setStatus(property.getDeleted().toString());
                attrDTOS.add(attrDTO);
            });
        }
        return attrDTOS;
    }
}

