/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin;

import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.sbc.nrosmember.client.model.dto.MemberLevelConfigDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Brand;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ChannelPrivilege;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Count;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Item;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ItemCondition;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Media;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Price;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ProductDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.PropertyValue;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.SaleUnit;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Sku;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.SkuPrice;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.enums.ProductTypeEnum;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.mdm.MdmProductRequestParam;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.ProductDetailVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.ProductPriceVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.SkuStoreVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.SkuVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.StoreItemVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.ItemService;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.BrandFeiginProxy;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.ClassFeignProxy;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.ItemFeignProxy;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.MemberFeignProxy;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.PropertyFeignProxy;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.SkuFeignProxy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemServiceImpl
implements ItemService {
    Logger logger = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Autowired
    private ItemFeignProxy itemFeignProxy;
    @Autowired
    private ClassFeignProxy classFeignProxy;
    @Autowired
    private BrandFeiginProxy brandFeiginProxy;
    @Autowired
    private SkuFeignProxy skuFeignProxy;
    @Autowired
    private PropertyFeignProxy propertyFeignProxy;
    @Autowired
    private MemberFeignProxy memberFeignProxy;

    @Override
    public List<ProductDTO> queryProducts(ItemCondition itemCondition) {
        ResponseMsg<List<Item>> listResponseMsg = this.itemFeignProxy.searchItemsForDB(itemCondition);
        List data = (List)listResponseMsg.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            ArrayList<ProductDTO> productDTOS = new ArrayList<ProductDTO>();
            for (Item item : data) {
                productDTOS.add(this.convertItem(item));
            }
            return productDTOS;
        }
        return null;
    }

    private ProductDTO convertItem(Item item) {
        String url;
        ProductDTO productDTO = new ProductDTO();
        productDTO.setCategoryId(item.getClassId());
        productDTO.setCategoryName(item.getClassName());
        productDTO.setId(item.getId());
        List<Media> medias = item.getMedias();
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(medias)) {
            for (Media media : medias) {
                stringBuilder.append(media.getUrl()).append(",");
            }
        }
        productDTO.setPicUrl(StringUtils.isNotBlank((String)(url = stringBuilder.toString())) && !"null".equals(url) ? url : null);
        SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        productDTO.setModifyDate(item.getGmtModified() == null ? null : sm.format(item.getGmtModified()));
        productDTO.setPostDate(item.getGmtCreate() == null ? null : sm.format(item.getGmtCreate()));
        productDTO.setProductName(item.getName());
        productDTO.setProductNumber(item.getItemCode());
        if (null != item.getSkuList() && null != item.getSkuList().get(0).getType()) {
            productDTO.setProductType(item.getSkuList().get(0).getType());
            productDTO.setProductTypeName("1".equals(item.getSkuList().get(0).getType()) ? "\u7ec4\u5408\u5546\u54c1" : "\u666e\u901a\u5546\u54c1");
        }
        if (item.getCreator() != null && !item.getCreator().isEmpty() && !"null".equals(item.getCreator())) {
            if (null != item.getCreator().get((Object)"userId")) {
                productDTO.setCreateUserId(new Long((String)item.getCreator().get((Object)"userId")));
            }
            productDTO.setPostUser((String)item.getCreator().get((Object)"userName"));
        }
        return productDTO;
    }

    @Override
    public ProductDetailVO queryProductById(Long id) {
        ResponseMsg<Item> item = this.itemFeignProxy.getItem(id);
        Item data = (Item)item.getData();
        if (null == data) {
            return null;
        }
        return this.convertProductDetail(data);
    }

    @Override
    public String addProduct(MdmProductRequestParam mdmProductRequest) {
        return null;
    }

    @Override
    public ResponseMsg<Item> getItem(Long id) {
        return this.itemFeignProxy.getItem(id);
    }

    @Override
    public ResponseMsg<Item> getItemByItemCode(String itemCode) {
        return this.itemFeignProxy.getItemByItemCode(itemCode);
    }

    @Override
    public ResponseMsg<List<ChannelPrivilege>> getChannelPrivileges(Long id) {
        return this.itemFeignProxy.getChannelPrivileges(id);
    }

    private ProductDetailVO convertProductDetail(Item item) {
        List<Media> medias;
        ProductDetailVO productDetailVO = new ProductDetailVO();
        BeanUtils.copyProperties((Object)item, (Object)productDetailVO);
        Brand brand = item.getBrand();
        if (null != brand) {
            Long brandId = brand.getId();
            try {
                ResponseMsg<Brand> brandDTOResponseMsg = this.brandFeiginProxy.getBrand(brandId);
                Brand data = (Brand)brandDTOResponseMsg.getData();
                if (null != data) {
                    productDetailVO.setBrandName(data.getName());
                }
            }
            catch (Exception e) {
                this.logger.info("\u67e5\u8be2\u54c1\u724c\u5931\u8d25:{}", (Throwable)e);
            }
        }
        productDetailVO.setCategoryName(item.getClassName());
        if (null != item.getSpu()) {
            productDetailVO.setProductTypeName(ProductTypeEnum.getName(item.getSpu().getType()));
        }
        productDetailVO.setProductName(item.getName());
        productDetailVO.setProductNumber(item.getItemCode());
        productDetailVO.setDescModules("");
        if (null != item.getBrand()) {
            productDetailVO.setBrandId(item.getBrand().getId());
            productDetailVO.setBrandName(item.getBrand().getName());
        }
        productDetailVO.setMemo(item.getDetail());
        productDetailVO.setCategoryId(item.getClassId());
        productDetailVO.setCategoryName(item.getClassName());
        List<Sku> skuList = item.getSkuList();
        if (CollectionUtils.isNotEmpty(skuList)) {
            ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
            ArrayList<SkuVO> skuVOS = new ArrayList<SkuVO>();
            try {
                for (Sku sku : skuList) {
                    List<Price> cost;
                    SkuPrice skuPrice;
                    ResponseMsg<List<SkuPrice>> skuPrices = this.skuFeignProxy.getSkuPrices(sku.getId());
                    SkuVO skuVO = new SkuVO();
                    List data = (List)skuPrices.getData();
                    if (CollectionUtils.isNotEmpty((Collection)data) && null != (skuPrice = (SkuPrice)data.get(0)) && CollectionUtils.isNotEmpty(cost = skuPrice.getCost())) {
                        Price price = cost.get(0);
                        skuVO.setCostPrice(price != null ? price.getCount().longValue() : 0L);
                        skuVO.setSalesPrice(price != null ? price.getCount().longValue() : 0L);
                    }
                    skuVO.setName(sku.getName());
                    Date gmtCreate = sku.getGmtCreate();
                    if (gmtCreate != null) {
                        skuVO.setPostDate(gmtCreate.getTime());
                    }
                    skuVO.setSkuNumber(sku.getSkuCode());
                    List<Media> medias2 = sku.getMedias();
                    if (CollectionUtils.isNotEmpty(medias2)) {
                        StringBuilder sb = new StringBuilder();
                        medias2.forEach(media -> sb.append(media.getUrl()).append(","));
                        String s = sb.toString();
                        skuVO.setSkuUrl(s.substring(0, s.length() - 1));
                    }
                    skuVO.setId(sku.getId());
                    skuVOS.add(skuVO);
                    productDetailVO.setSkuList(skuVOS);
                    List<SaleUnit> saleUnits = sku.getSaleUnits();
                    if (CollectionUtils.isNotEmpty(saleUnits)) {
                        productDetailVO.setUnit(saleUnits.get(0).getName());
                    }
                    properties.addAll(sku.getKeyPropertyValues());
                    properties.addAll(sku.getNormalPropertyValues());
                    properties.addAll(sku.getSalePropertyValues());
                }
            }
            catch (Exception e) {
                this.logger.info("\u67e5\u8be2sku\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            ArrayList<Map<String, String>> titleList = new ArrayList<Map<String, String>>();
            if (CollectionUtils.isNotEmpty(properties)) {
                for (int i = 0; i < properties.size(); ++i) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("title", ((PropertyValue)properties.get(i)).getProperty().getName());
                    map.put("dataIndex", "attribute" + (i + 1));
                    titleList.add(map);
                }
            }
            productDetailVO.setTitleList(titleList);
        }
        if (CollectionUtils.isNotEmpty(medias = item.getMedias())) {
            ArrayList<String> list = new ArrayList<String>();
            for (Media media2 : medias) {
                list.add(media2.getUrl());
            }
            productDetailVO.setPicList(list);
            if (null != list) {
                productDetailVO.setPicUrl((String)list.get(0));
            }
        }
        return productDetailVO;
    }

    @Override
    public Count getItemCount(ItemCondition itemCondition) {
        ResponseMsg<Count> itemCount = this.itemFeignProxy.getItemCount(itemCondition);
        return null == itemCount ? null : (Count)itemCount.getData();
    }

    @Override
    public List<StoreItemVO> searchStoreItems(ItemCondition itemCondition) {
        ArrayList<StoreItemVO> storeItemVOS = new ArrayList<StoreItemVO>();
        List data = (List)this.itemFeignProxy.searchStoreItems(itemCondition).getData();
        for (Item item : data) {
            StoreItemVO storeItemVO = new StoreItemVO();
            storeItemVO.setId(item.getId());
            storeItemVO.setProductId(item.getId());
            storeItemVO.setCategoryId(item.getClassId());
            storeItemVO.setCommonName(item.getName());
            storeItemVO.setBrandId(item.getBrand().getId());
            String url = "";
            for (Media media : item.getMedias()) {
                url = url + media.getUrl();
            }
            storeItemVO.setPicUrl(url);
            if (null != item.getSkuList() && null != item.getSkuList().get(0) && null != item.getSkuList().get(0).getPriceMatrix() && null != item.getSkuList().get(0).getPriceMatrix().get(0)) {
                storeItemVO.setPrice(item.getSkuList().get(0).getPriceMatrix().get(0).getCost().get(0).getCount());
                storeItemVO.setCostPrice(item.getSkuList().get(0).getPriceMatrix().get(0).getCost().get(0).getCount());
            }
            ArrayList<SkuStoreVO> skuList = new ArrayList<SkuStoreVO>();
            if (null != item.getSkuList()) {
                for (Sku sku : item.getSkuList()) {
                    SkuStoreVO skuStoreVO = new SkuStoreVO();
                    skuStoreVO.setProductId(item.getId());
                    skuStoreVO.setSkuName(sku.getName());
                    skuStoreVO.setSkuNumber(sku.getId());
                    if (null != sku.getMedias() && sku.getMedias().size() > 0) {
                        String meUrl = "";
                        for (Media media : sku.getMedias()) {
                            meUrl = meUrl + media.getUrl();
                        }
                        skuStoreVO.setSkuUrl(meUrl);
                    }
                    skuStoreVO.setSalesPrice(storeItemVO.getPrice());
                    skuStoreVO.setCostPrice(storeItemVO.getCostPrice());
                    skuList.add(skuStoreVO);
                }
            }
            storeItemVO.setSkuList(skuList);
            storeItemVOS.add(storeItemVO);
        }
        return storeItemVOS;
    }

    @Override
    public ProductPriceVO searchItemPriceByCode(String code, String channelId, String storeCode, String memberLevel, String memberCategory) {
        MemberLevelConfigDTO data;
        String levelId = null;
        if (StringUtils.isNotBlank((String)memberLevel) && StringUtils.isNotBlank((String)memberCategory) && null != (data = (MemberLevelConfigDTO)this.memberFeignProxy.findByLevel(Long.valueOf(memberCategory), Integer.parseInt(memberLevel)).getData())) {
            levelId = data.getId() + "";
        }
        ResponseMsg<Item> itemResponseMsg = this.itemFeignProxy.searchItemPriceByCode(code, channelId, storeCode, levelId);
        ProductPriceVO productPriceVO = new ProductPriceVO();
        if (null != itemResponseMsg.getData()) {
            productPriceVO.setProductName(((Item)itemResponseMsg.getData()).getName());
            productPriceVO.setPrice(null == ((Item)itemResponseMsg.getData()).getMinPrice() ? ((Item)itemResponseMsg.getData()).getMaxPrice() : ((Item)itemResponseMsg.getData()).getMinPrice());
            productPriceVO.setOriginalPrice(((Item)itemResponseMsg.getData()).getMaxPrice());
        }
        return productPriceVO;
    }
}

