/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin;

import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Category;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.CategoryVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.CategoryService;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.CategoryFeignProxy;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceImpl
implements CategoryService {
    @Autowired
    private CategoryFeignProxy categoryFeignProxy;

    @Override
    public List<CategoryVO> queryCategoryList(Integer type) {
        ResponseMsg<List<Category>> allCategory = this.categoryFeignProxy.getAllCategory(type);
        ArrayList<CategoryVO> categoryVO = new ArrayList<CategoryVO>();
        if (null == allCategory || null == allCategory.getData() || ((List)allCategory.getData()).size() == 0) {
            return categoryVO;
        }
        for (Category category : (List)allCategory.getData()) {
            categoryVO.add(this.setCategory(category, null));
        }
        return categoryVO;
    }

    @Override
    public ResponseMsg<List<Category>> queryRootCategory(Integer type) {
        return this.categoryFeignProxy.getRootCategory(type);
    }

    @Override
    public ResponseMsg<List<Category>> queryCategoryChildren(Long id) {
        return this.categoryFeignProxy.getCategoryChildren(id);
    }

    @Override
    public Category queryCategoryById(Long categoryId) {
        return null;
    }

    private CategoryVO setCategory(Category category, String parentName) {
        CategoryVO categoryVO = new CategoryVO();
        categoryVO.setId(category.getId());
        categoryVO.setName(category.getName());
        categoryVO.setLevel(category.getLevel());
        categoryVO.setPicPath(category.getUrl());
        categoryVO.setShowFlag(1);
        categoryVO.setParentId(-1L == category.getParentId() ? null : category.getParentId());
        categoryVO.setParentName(parentName);
        if (null != category.getChildren()) {
            ArrayList<CategoryVO> parent = new ArrayList<CategoryVO>();
            for (Category son : category.getChildren()) {
                parent.add(this.setCategory(son, category.getName()));
            }
            categoryVO.setChildren(parent);
        }
        return categoryVO;
    }
}

