/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin;

import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Brand;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.BrandDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.mdm.MdmBrandDataDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.mdm.MdmBrandRequestParam;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.mdm.MdmReturnApiUtils;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.query.BrandQuery;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.BrandService;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.feigin.proxy.BrandFeiginProxy;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrandServiceImpl
implements BrandService {
    @Autowired
    BrandFeiginProxy brandFeiginProxy;

    @Override
    public Brand findById(Long id) {
        return (Brand)this.brandFeiginProxy.getBrand(id).getData();
    }

    @Override
    public void save(BrandDTO brandDTO) {
    }

    @Override
    public void delete(Long id) {
    }

    @Override
    public ResponseMsg<List<BrandDTO>> queryBrandList(BrandQuery brandQuery) {
        return this.brandFeiginProxy.searchBrands(brandQuery.getName(), brandQuery.getPageIndex(), brandQuery.getPageSize());
    }

    @Override
    public Brand queryBrandById(Long brandId) {
        return this.findById(brandId);
    }

    @Override
    public String downBrandInfo(MdmBrandRequestParam mdmBrandRequestParam) {
        if (mdmBrandRequestParam == null) {
            return MdmReturnApiUtils.returnContainBatchFailure("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        List<MdmBrandDataDTO> requestData = mdmBrandRequestParam.getRequest().getRequestData();
        if (CollectionUtils.isEmpty(requestData)) {
            return MdmReturnApiUtils.returnContainBatchFailure("\u63a8\u9001\u6570\u636e\u4e3a\u7a7a");
        }
        String batchNo = null;
        for (MdmBrandDataDTO mdmBrandDataDTO : requestData) {
            batchNo = mdmBrandDataDTO.getBatchNo();
            BrandDTO brand = (BrandDTO)this.brandFeiginProxy.getBrandByNumber(mdmBrandDataDTO.getBrandCode()).getData();
            if (null != brand) {
                brand.setName(mdmBrandDataDTO.getBrandName());
                this.brandFeiginProxy.updateBrandById(brand);
                continue;
            }
            brand = new BrandDTO();
            brand.setId(mdmBrandDataDTO.getBrandId());
            brand.setName(mdmBrandDataDTO.getBrandName());
            brand.setRemark(mdmBrandDataDTO.getBrandDescription());
            brand.setSynStatus(Short.valueOf("0"));
            this.brandFeiginProxy.createBrand(brand);
        }
        return MdmReturnApiUtils.returnContainBatchSuccess(batchNo);
    }
}

