/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.controller;

import com.ztesoft.zsmart.nros.base.annotation.AppSecretController;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.common.ResponseResult;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ChannelPrivilege;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Item;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.ItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@AppSecretController
@RequestMapping(value={"/oms/products"})
@Api(value="\u5546\u54c1\u7ba1\u7406", tags={"\u5546\u54c1\u7ba1\u7406"})
public class ItemV2Controller {
    @Autowired
    private ItemService itemService;

    @GetMapping(value={"/channel/{productNumber}"})
    @ApiOperation(value="\u83b7\u53d6\u6e20\u9053\u8be6\u60c5", notes="\u83b7\u53d6\u6e20\u9053\u8be6\u60c5")
    public ResponseResult getChannel(@PathVariable(value="productNumber") String productNumber) {
        ResponseResult<List> responseResult = new ResponseResult<List>();
        if (StringUtils.isBlank((CharSequence)productNumber)) {
            responseResult.setHttpcode(500);
            responseResult.setMessage("NROS-SBC-ITEMCENTER-0008");
            return responseResult;
        }
        ChannelPrivilege channelPrivilege = new ChannelPrivilege();
        Item item = (Item)this.itemService.getItemByItemCode(productNumber).getData();
        if (item == null) {
            responseResult.setHttpcode(500);
            responseResult.setMessage("NROS-SBC-ITEMCENTER-0008");
            return responseResult;
        }
        channelPrivilege.setProductName(item.getName());
        List channelPrivilegeList = (List)this.itemService.getChannelPrivileges(item.getId()).getData();
        if (CollectionUtils.isNotEmpty((Collection)channelPrivilegeList)) {
            channelPrivilege.setChannel(((ChannelPrivilege)channelPrivilegeList.get(0)).getChannelName());
        }
        responseResult.setMessage("success");
        responseResult.setHttpcode(200);
        responseResult.setData(channelPrivilegeList);
        return responseResult;
    }
}

