/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.controller;

import com.ztesoft.zsmart.nros.base.annotation.AppSecretController;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.common.ResponseResult;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.ProductPriceVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.ItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@AppSecretController
@RequestMapping(value={"/v1/oms/products"})
@Api(value="\u5546\u54c1\u4ef7\u683c\u7ba1\u7406", tags={"\u5546\u54c1\u4ef7\u683c\u7ba1\u7406"})
public class ItemPriceController {
    @Autowired
    private ItemService itemService;

    @GetMapping(value={"/price"})
    @ApiOperation(value="\u5546\u54c1\u4ef7\u683c\u67e5\u8be2", notes="\u5546\u54c1\u4ef7\u683c\u67e5\u8be2")
    public ResponseResult searchProductPrice(@RequestParam(value="productNumber") String productNumber, @RequestParam(value="channelId", required=false) String channelId, @RequestParam(value="storeCode", required=false) String storeCode, @RequestParam(value="memberLevel", required=false) String memberLevel, @RequestParam(value="memberCategory", required=false) String memberCategory) {
        ResponseResult<ProductPriceVO> responseResult = new ResponseResult<ProductPriceVO>();
        ProductPriceVO productPriceVO = null;
        try {
            productPriceVO = this.itemService.searchItemPriceByCode(productNumber, channelId, storeCode, memberLevel, memberCategory);
        }
        catch (BusiException e) {
            responseResult.setHttpcode(500);
            responseResult.setMessage(e.getErrorMsg());
            return responseResult;
        }
        responseResult.setHttpcode(200);
        responseResult.setMessage("success");
        responseResult.setData(productPriceVO);
        return responseResult;
    }
}

