/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.controller;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.annotation.AppSecretController;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.common.ResponseResult;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.controller.PropertyController;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.AttrDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Count;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Item;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ItemCondition;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ProductDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.query.PropertyQuery;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.CategoryVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.PageVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.ProductApiVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.ProductDetailVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.CategoryService;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.ItemService;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.PropertyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@AppSecretController
@RequestMapping(value={"/v1/oms/products"})
@Api(value="\u5546\u54c1\u4fe1\u606f", tags={"\u5546\u54c1\u4fe1\u606f"})
public class ItemInfoController {
    @Autowired
    private ItemService itemService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private PropertyService propertyService;
    private static final Logger logger = LoggerFactory.getLogger(PropertyController.class);

    @GetMapping(value={""})
    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u5217\u8868", notes="\u83b7\u53d6\u5546\u54c1\u5217\u8868")
    public ResponseResult listProduct(String pageNo, String pageSize, String categoryId, String productType, String createUserId, String condition) {
        ItemCondition itemCondition = new ItemCondition();
        itemCondition.setCreatorId(createUserId);
        itemCondition.setKeyWord(condition);
        itemCondition.setPageIndex(StringUtils.isBlank((String)pageNo) ? null : Integer.valueOf(Integer.parseInt(pageNo)));
        itemCondition.setPageSize(StringUtils.isBlank((String)pageSize) ? null : Integer.valueOf(Integer.parseInt(pageSize)));
        itemCondition.setType(StringUtils.isBlank((String)productType) ? null : Integer.valueOf(Integer.parseInt(productType)));
        if (StringUtils.isNotBlank((String)productType) && StringUtils.isNotBlank((String)categoryId)) {
            ArrayList<Long> inClassIds = new ArrayList<Long>();
            inClassIds.add(new Long(categoryId));
            itemCondition.setInClassIds(inClassIds);
        }
        List<ProductDTO> productDTOList = this.itemService.queryProducts(itemCondition);
        Count itemCount = this.itemService.getItemCount(itemCondition);
        ProductApiVO productApiDTO = new ProductApiVO();
        if (CollectionUtils.isNotEmpty(productDTOList)) {
            productApiDTO.setListItemDTOS(productDTOList);
        }
        productApiDTO.setNumber(new Long(pageNo));
        productApiDTO.setSize(new Long(pageSize));
        if (null != itemCount) {
            productApiDTO.setTotalElements(itemCount.getTotal());
            productApiDTO.setTotalProductCount(itemCount.getTotal());
            productApiDTO.setCombinationProductCount(itemCount.getCombinationCount());
            productApiDTO.setGeneralProductCount(itemCount.getGeneralCount());
        }
        ResponseResult<ProductApiVO> responseResult = new ResponseResult<ProductApiVO>();
        responseResult.setHttpcode(200);
        responseResult.setMessage("success");
        responseResult.setData(productApiDTO);
        return responseResult;
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u8be6\u60c5", notes="\u83b7\u53d6\u5546\u54c1\u8be6\u60c5")
    public ResponseResult getProduct(@PathVariable(value="id") String id) {
        Long itemId;
        ResponseResult<ProductDetailVO> responseResult = new ResponseResult<ProductDetailVO>();
        Item item = (Item)this.itemService.getItemByItemCode(id).getData();
        if (null != item) {
            id = item.getId().toString();
        }
        try {
            itemId = Long.valueOf(id);
        }
        catch (Exception e) {
            responseResult.setHttpcode(500);
            responseResult.setMessage("\u5546\u54c1id\u6216\u5546\u54c1code\u8f93\u5165\u6709\u8bef");
            return responseResult;
        }
        ProductDetailVO productDetailVO = this.itemService.queryProductById(itemId);
        if (null == productDetailVO) {
            responseResult.setHttpcode(500);
            responseResult.setMessage("\u5546\u54c1id\u6216\u5546\u54c1code\u8f93\u5165\u6709\u8bef");
            return responseResult;
        }
        responseResult.setMessage("success");
        responseResult.setHttpcode(200);
        responseResult.setData(productDetailVO);
        return responseResult;
    }

    @RequestMapping(value={"/categories"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5546\u54c1\u5206\u7c7b\u5217\u8868")
    public ResponseResult queryCategoryList() {
        Integer type = 1;
        ResponseResult<List<CategoryVO>> responseResult = new ResponseResult<List<CategoryVO>>();
        List<CategoryVO> categoryVOS = this.categoryService.queryCategoryList(type);
        responseResult.setMessage("success");
        responseResult.setHttpcode(200);
        responseResult.setData(categoryVOS);
        return responseResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/attrs"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5546\u54c1\u5c5e\u6027\u5217\u8868")
    public ResponseResult listAttrs(String pageNo, String pageSize, String condition) {
        PropertyQuery propertyQuery = new PropertyQuery();
        ResponseResult<PageVO> responseResult = new ResponseResult<PageVO>();
        Page page = PageHelper.startPage((int)Integer.parseInt(pageNo), (int)Integer.parseInt(pageSize));
        propertyQuery.setCondition(condition);
        propertyQuery.setPageIndex(Integer.parseInt(pageNo));
        propertyQuery.setPageSize(Integer.parseInt(pageSize));
        try {
            List<AttrDTO> attrDOS = this.propertyService.queryAttrDOs(propertyQuery);
            PageInfo pageInfo = page.toPageInfo();
            PageVO pageApi = new PageVO();
            pageApi.setFirst(true);
            pageApi.setLast(true);
            pageApi.setNumber(propertyQuery.getPageSize());
            pageApi.setNumberOfElements((int)pageInfo.getTotal());
            pageApi.setSize(propertyQuery.getPageSize());
            pageApi.setTotalElements((int)pageInfo.getTotal());
            pageApi.setContent(attrDOS);
            pageApi.setTotalPages(pageInfo.getPages());
            responseResult.setMessage("success");
            responseResult.setHttpcode(200);
            responseResult.setData(pageApi);
        }
        catch (Exception e) {
            responseResult.setHttpcode(500);
            logger.error("fail to PropertyController listAttrs...", (Throwable)e);
        }
        finally {
            return responseResult;
        }
    }
}

