/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.controller;

import com.ztesoft.zsmart.nros.base.annotation.AppSecretController;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.common.ResponseResult;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Count;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ItemCondition;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.ProductDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.mdm.MdmProductRequestParam;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.ProductApiVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.vo.ProductDetailVO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.ItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@AppSecretController
@RequestMapping(value={"/item"})
@Api(value="\u5546\u54c1\u7ba1\u7406", tags={"\u5546\u54c1\u7ba1\u7406"})
public class ItemController {
    @Autowired
    private ItemService itemService;

    @GetMapping(value={""})
    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u5217\u8868", notes="\u83b7\u53d6\u5546\u54c1\u5217\u8868")
    public ResponseResult listProduct(String pageNo, String pageSize, String categoryId, String productType, String createUserId, String condition) {
        ItemCondition itemCondition = new ItemCondition();
        itemCondition.setCreatorId(createUserId);
        itemCondition.setKeyWord(condition);
        itemCondition.setPageIndex(StringUtils.isBlank((String)pageNo) ? null : Integer.valueOf(Integer.parseInt(pageNo)));
        itemCondition.setPageSize(StringUtils.isBlank((String)pageSize) ? null : Integer.valueOf(Integer.parseInt(pageSize)));
        itemCondition.setType(StringUtils.isBlank((String)productType) ? null : Integer.valueOf(Integer.parseInt(productType)));
        if (StringUtils.isNotBlank((String)productType)) {
            ArrayList<Long> inClassIds = new ArrayList<Long>();
            inClassIds.add(new Long(categoryId));
            itemCondition.setInClassIds(inClassIds);
        }
        List<ProductDTO> productDTOList = this.itemService.queryProducts(itemCondition);
        Count itemCount = this.itemService.getItemCount(itemCondition);
        ProductApiVO productApiDTO = new ProductApiVO();
        if (CollectionUtils.isNotEmpty(productDTOList)) {
            productApiDTO.setListItemDTOS(productDTOList);
        }
        productApiDTO.setNumber(new Long(pageNo));
        productApiDTO.setSize(new Long(pageSize));
        if (null != itemCount) {
            productApiDTO.setTotalElements(itemCount.getTotal());
            productApiDTO.setTotalProductCount(itemCount.getTotal());
            productApiDTO.setCombinationProductCount(itemCount.getCombinationCount());
            productApiDTO.setGeneralProductCount(itemCount.getGeneralCount());
        }
        ResponseResult<ProductApiVO> responseResult = new ResponseResult<ProductApiVO>();
        responseResult.setHttpcode(200);
        responseResult.setMessage("success");
        responseResult.setData(productApiDTO);
        return responseResult;
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u8be6\u60c5", notes="\u83b7\u53d6\u5546\u54c1\u8be6\u60c5")
    public ResponseResult getProduct(@PathVariable(value="id") Long id) {
        ResponseResult<ProductDetailVO> responseResult = new ResponseResult<ProductDetailVO>();
        if (id == null || id == 0L) {
            responseResult.setHttpcode(500);
            responseResult.setMessage("NROS-SBC-ITEMCENTER-0008");
            return responseResult;
        }
        ProductDetailVO productDetailVO = this.itemService.queryProductById(id);
        responseResult.setMessage("success");
        responseResult.setHttpcode(200);
        responseResult.setData(productDetailVO);
        return responseResult;
    }

    @PostMapping(value={"/downProductData"})
    @ApiOperation(value="\u63a5\u6536MDM\u63a8\u9001\u7684\u5546\u54c1\u4e3b\u6570\u636e", notes="\u63a5\u6536MDM\u63a8\u9001\u7684\u5546\u54c1\u4e3b\u6570\u636e")
    public String downProductData(@RequestBody @Validated MdmProductRequestParam mdmProductRequest) {
        return this.itemService.addProduct(mdmProductRequest);
    }
}

