/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.prj.trt.item.controller;

import com.ztesoft.zsmart.nros.base.annotation.AppSecretController;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.common.ResponseResult;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Brand;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.BrandDTO;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.model.dto.Item;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.BrandService;
import com.ztesoft.zsmart.nros.sbc.prj.trt.item.service.ItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@AppSecretController
@RequestMapping(value={"/oms/brands"})
@Api(value="\u54c1\u724c\u7ba1\u7406", tags={"\u54c1\u724c\u7ba1\u7406"})
public class BrandV2Controller {
    @Autowired
    private BrandService brandService;
    @Autowired
    private ItemService itemService;

    @RequestMapping(value={"/{productNumber}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u54c1\u724c\u4fe1\u606f", notes="\u83b7\u53d6\u54c1\u724c\u4fe1\u606f")
    public ResponseResult queryBrand(@PathVariable(value="productNumber") String productNumber) {
        ResponseResult<BrandDTO> responseResult = new ResponseResult<BrandDTO>();
        if (StringUtils.isBlank((CharSequence)productNumber)) {
            responseResult.setHttpcode(500);
            responseResult.setMessage("NROS-SBC-ITEMCENTER-0005");
            return responseResult;
        }
        Item item = (Item)this.itemService.getItemByItemCode(productNumber).getData();
        if (item == null || item.getBrand() == null) {
            responseResult.setHttpcode(500);
            responseResult.setMessage("NROS-SBC-ITEMCENTER-0005");
            return responseResult;
        }
        Brand brand = item.getBrand();
        BrandDTO brandDTO = new BrandDTO();
        BeanUtils.copyProperties((Object)brand, (Object)brandDTO);
        brandDTO.setLogo(brand.getLogoUrl());
        brandDTO.setRemark(brand.getDetail());
        responseResult.setMessage("success");
        responseResult.setHttpcode(200);
        responseResult.setData(brandDTO);
        return responseResult;
    }
}

